/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v2.impl;

import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.AbstractDataSetImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.ExperimentImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.ExternalDataManagementSystemImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.SampleImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedBasicOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IDataSetImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IExperimentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IExternalDataManagementSystemImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISampleImmutable;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.dataset.DataSetCodeId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DataSetImmutable
extends AbstractDataSetImmutable {
    protected final AbstractExternalData dataSet;

    public DataSetImmutable(AbstractExternalData dataSet, IEncapsulatedBasicOpenBISService service) {
        super(service);
        this.dataSet = dataSet;
    }

    @Override
    public String getDataSetCode() {
        return this.dataSet.getCode();
    }

    @Override
    public IObjectId getEntityId() {
        return new DataSetCodeId(this.getDataSetCode());
    }

    @Override
    public IExperimentImmutable getExperiment() {
        return new ExperimentImmutable(this.dataSet.getExperiment());
    }

    @Override
    public ISampleImmutable getSample() {
        Sample sample = this.dataSet.getSample();
        if (sample == null) {
            return null;
        }
        return new SampleImmutable(sample);
    }

    @Override
    public String getFileFormatType() {
        if (this.isContainerDataSet()) {
            return null;
        }
        return this.dataSet.tryGetAsDataSet().getFileFormatType().getCode();
    }

    @Override
    public boolean isMeasuredData() {
        return !this.dataSet.isDerived();
    }

    @Override
    public int getSpeedHint() {
        if (this.isContainerDataSet()) {
            return Integer.MIN_VALUE;
        }
        return this.dataSet.tryGetAsDataSet().getSpeedHint();
    }

    @Override
    public String getDataSetType() {
        return this.dataSet.getDataSetType().getCode();
    }

    @Override
    public DataSetType getDataSetTypeWithPropertyTypes() {
        return this.getDataSetTypeWithPropertyTypes(this.getDataSetType());
    }

    @Override
    public String getPropertyValue(String propertyCode) {
        return EntityHelper.tryFindPropertyValue(this.dataSet, propertyCode);
    }

    @Override
    public List<String> getAllPropertyCodes() {
        List<IEntityProperty> properties = this.dataSet.getProperties();
        ArrayList<String> codes = new ArrayList<String>();
        for (IEntityProperty property : properties) {
            codes.add(property.getPropertyType().getCode());
        }
        return codes;
    }

    @Override
    public List<String> getParentDatasets() {
        return Code.extractCodes(this.dataSet.getParents());
    }

    @Override
    public boolean isContainerDataSet() {
        return this.dataSet.isContainer();
    }

    @Override
    public boolean isContainedDataSet() {
        return this.dataSet.tryGetContainer() != null;
    }

    @Override
    public String getContainerDataSet() {
        ContainerDataSet container = this.dataSet.tryGetContainer();
        if (container != null) {
            return container.getCode();
        }
        return null;
    }

    @Override
    public List<String> getContainedDataSetCodes() {
        if (this.isContainerDataSet()) {
            return Code.extractCodes(this.dataSet.tryGetAsContainerDataSet().getContainedDataSets());
        }
        return Collections.emptyList();
    }

    @Override
    public List<IDataSetImmutable> getChildrenDataSets() {
        ArrayList<IDataSetImmutable> result = new ArrayList<IDataSetImmutable>();
        Collection<AbstractExternalData> children = this.dataSet.getChildren();
        if (children != null) {
            for (AbstractExternalData child : children) {
                result.add(new DataSetImmutable(child, this.service));
            }
        }
        return result;
    }

    @Override
    public boolean isLinkDataSet() {
        return this.dataSet.tryGetAsLinkDataSet() != null;
    }

    @Override
    public IExternalDataManagementSystemImmutable getExternalDataManagementSystem() {
        ExternalDataManagementSystem externalDMS = this.dataSet.tryGetAsLinkDataSet().getExternalDataManagementSystem();
        if (externalDMS != null) {
            return new ExternalDataManagementSystemImmutable(externalDMS);
        }
        return null;
    }

    @Override
    public String getExternalCode() {
        return this.dataSet.tryGetAsLinkDataSet().getExternalCode();
    }

    @Override
    public boolean isNoFileDataSet() {
        return this.isContainerDataSet() || this.isLinkDataSet();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetImmutable)) {
            return false;
        }
        DataSetImmutable other = (DataSetImmutable)obj;
        return !(this.getDataSetCode() == null ? other.getDataSetCode() != null : !this.getDataSetCode().equals(other.getDataSetCode()));
    }

    @Override
    public boolean isPostRegistered() {
        return this.dataSet.isPostRegistered();
    }
}

