/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v2.impl;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.ConversionUtils;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.DataSetImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.ExperimentImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.MaterialImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.MetaprojectAssignments;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.MetaprojectImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.ProjectImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.PropertyAssignmentImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.SampleImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.SpaceImmutable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.VocabularyImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedBasicOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IDataSetImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IExperimentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IMaterialImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IMetaprojectAssignments;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IMetaprojectContent;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IMetaprojectImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IProjectImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IPropertyAssignmentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISampleImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISearchService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISpaceImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IVocabularyImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.MaterialIdentifierCollection;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.Transformer;

public class SearchService
implements ISearchService {
    private final IEncapsulatedBasicOpenBISService openBisService;

    public SearchService(IEncapsulatedBasicOpenBISService openBisService) {
        this.openBisService = openBisService;
    }

    @Override
    public IProjectImmutable getProject(String projectIdentifierString) {
        ProjectIdentifier projectIdentifier = new ProjectIdentifierFactory(projectIdentifierString).createIdentifier();
        Project projectOrNull = this.openBisService.tryGetProject(projectIdentifier);
        return projectOrNull == null ? null : new ProjectImmutable(projectOrNull);
    }

    @Override
    public ISpaceImmutable getSpace(String spaceCode) {
        SpaceIdentifier spaceIdentifier = new SpaceIdentifier(spaceCode);
        Space spaceOrNull = this.openBisService.tryGetSpace(spaceIdentifier);
        return spaceOrNull == null ? null : new SpaceImmutable(spaceOrNull);
    }

    @Override
    public List<IExperimentImmutable> listExperiments(String projectIdentifierString) {
        ProjectIdentifier projectIdentifier = new ProjectIdentifierFactory(projectIdentifierString.toUpperCase()).createIdentifier();
        List<Experiment> serverExperiments = this.openBisService.listExperiments(projectIdentifier);
        ArrayList<IExperimentImmutable> experiments = new ArrayList<IExperimentImmutable>(serverExperiments.size());
        for (Experiment experiment : serverExperiments) {
            experiments.add(new ExperimentImmutable(experiment));
        }
        return experiments;
    }

    @Override
    public List<IDataSetImmutable> searchForDataSets(String property, String value, String typeOrNull) {
        return this.searchForDataSets(property, value, typeOrNull, false);
    }

    @Override
    public List<IDataSetImmutable> searchForDataSets(String property, String value, String typeOrNull, boolean escape) {
        SearchCriteria sc = new SearchCriteria();
        if (typeOrNull != null) {
            sc.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.TYPE, typeOrNull));
        }
        sc.addMatchClause(SearchCriteria.MatchClause.createPropertyMatch(property, escape ? SearchCriteria.MatchClause.escape(value) : value));
        return this.searchForDataSets(sc);
    }

    @Override
    public List<ISampleImmutable> searchForSamples(String property, String value, String typeOrNull) {
        return this.searchForSamples(property, value, typeOrNull, false);
    }

    @Override
    public List<ISampleImmutable> searchForSamples(String property, String value, String typeOrNull, boolean escape) {
        SearchCriteria sc = new SearchCriteria();
        if (typeOrNull != null) {
            sc.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch(SearchCriteria.MatchClauseAttribute.TYPE, typeOrNull));
        }
        sc.addMatchClause(SearchCriteria.MatchClause.createPropertyMatch(property, escape ? SearchCriteria.MatchClause.escape(value) : value));
        return this.searchForSamples(sc);
    }

    @Override
    public List<IDataSetImmutable> searchForDataSets(SearchCriteria searchCriteria) {
        List<AbstractExternalData> serverDataSets = this.openBisService.searchForDataSets(searchCriteria);
        ArrayList<IDataSetImmutable> dataSets = new ArrayList<IDataSetImmutable>(serverDataSets.size());
        for (AbstractExternalData dataSet : serverDataSets) {
            dataSets.add(new DataSetImmutable(dataSet, this.openBisService));
        }
        return dataSets;
    }

    @Override
    public List<ISampleImmutable> searchForSamples(SearchCriteria searchCriteria) {
        List<Sample> serverSamples = this.openBisService.searchForSamples(searchCriteria);
        ArrayList<ISampleImmutable> samples = new ArrayList<ISampleImmutable>(serverSamples.size());
        for (Sample sample : serverSamples) {
            samples.add(new SampleImmutable(sample, EnumSet.of(SampleFetchOption.BASIC, SampleFetchOption.PROPERTIES)));
        }
        return samples;
    }

    @Override
    public List<IExperimentImmutable> searchForExperiments(SearchCriteria searchCriteria) {
        List<Experiment> serverExperiments = this.openBisService.searchForExperiments(searchCriteria);
        ArrayList<IExperimentImmutable> experiments = new ArrayList<IExperimentImmutable>(serverExperiments.size());
        for (Experiment experiment : serverExperiments) {
            experiments.add(new ExperimentImmutable(experiment));
        }
        return experiments;
    }

    @Override
    public List<IMaterialImmutable> listMaterials(MaterialIdentifierCollection identifierCollection) {
        final HashSet<String> identifiers = new HashSet<String>(identifierCollection.getIdentifiers());
        Set<String> searchedTypes = this.extractMaterialTypes(identifierCollection);
        List<Material> accumulatedResults = this.findAllMaterials(searchedTypes);
        List<Material> filteredByIdentifier = CollectionUtils.filter(accumulatedResults, new CollectionUtils.ICollectionFilter<Material>(){

            @Override
            public boolean isPresent(Material element) {
                return identifiers.contains(element.getIdentifier());
            }
        });
        return this.translate(filteredByIdentifier);
    }

    private Set<String> extractMaterialTypes(MaterialIdentifierCollection identifierCollection) {
        HashSet<String> searchedTypes = new HashSet<String>();
        for (String stringIdentifier : identifierCollection.getIdentifiers()) {
            MaterialIdentifier identifier = MaterialIdentifier.tryParseIdentifier(stringIdentifier);
            searchedTypes.add(identifier.getTypeCode());
        }
        return searchedTypes;
    }

    private List<Material> findAllMaterials(Set<String> searchedTypes) {
        ArrayList<Material> accumulatedResults = new ArrayList<Material>();
        for (String typeCode : searchedTypes) {
            MaterialType materialType = new MaterialType();
            materialType.setCode(typeCode);
            List<Material> materialsOfType = this.openBisService.listMaterials(ListMaterialCriteria.createFromMaterialType(materialType), true);
            accumulatedResults.addAll(materialsOfType);
        }
        return accumulatedResults;
    }

    @Override
    public List<IMaterialImmutable> listAllMaterials(String materialTypeCode) {
        MaterialType materialType = new MaterialType();
        materialType.setCode(materialTypeCode);
        List<Material> materialsOfType = this.openBisService.listMaterials(ListMaterialCriteria.createFromMaterialType(materialType), true);
        return this.translate(materialsOfType);
    }

    private List<IMaterialImmutable> translate(List<Material> materials) {
        ArrayList<IMaterialImmutable> result = new ArrayList<IMaterialImmutable>();
        for (Material material : materials) {
            result.add(new MaterialImmutable(material));
        }
        return result;
    }

    @Override
    public IVocabularyImmutable searchForVocabulary(String code) {
        return this.getVocabulary(code);
    }

    @Override
    public IVocabularyImmutable getVocabulary(String code) {
        Vocabulary vocabulary = this.openBisService.tryGetVocabulary(code);
        return vocabulary == null ? null : new VocabularyImmutable(vocabulary);
    }

    @Override
    public List<IPropertyAssignmentImmutable> listPropertiesDefinitionsForDataSetType(String code) {
        return this.listPropertyDefinitions(code, EntityKind.DATA_SET);
    }

    @Override
    public List<IPropertyAssignmentImmutable> listPropertiesDefinitionsForExperimentType(String code) {
        return this.listPropertyDefinitions(code, EntityKind.EXPERIMENT);
    }

    @Override
    public List<IPropertyAssignmentImmutable> listPropertiesDefinitionsForMaterialType(String code) {
        return this.listPropertyDefinitions(code, EntityKind.MATERIAL);
    }

    @Override
    public List<IPropertyAssignmentImmutable> listPropertiesDefinitionsForSampleType(String code) {
        return this.listPropertyDefinitions(code, EntityKind.SAMPLE);
    }

    private List<IPropertyAssignmentImmutable> listPropertyDefinitions(String code, EntityKind kind) {
        List<? extends EntityTypePropertyType<?>> apiList = this.openBisService.listPropertyDefinitionsForEntityType(code, kind);
        Transformer transformer = new Transformer<EntityTypePropertyType<?>, IPropertyAssignmentImmutable>(){

            public IPropertyAssignmentImmutable transform(EntityTypePropertyType<?> input) {
                return new PropertyAssignmentImmutable(input);
            }
        };
        Collection transformed = org.apache.commons.collections.CollectionUtils.collect(apiList, (Transformer)transformer);
        return new LinkedList<IPropertyAssignmentImmutable>(transformed);
    }

    @Override
    public List<IMetaprojectImmutable> listMetaprojects() {
        List<Metaproject> metaprojects = this.openBisService.listMetaprojects();
        return ConversionUtils.convertToMetaprojectsImmutable(metaprojects);
    }

    @Override
    public IMetaprojectImmutable getMetaproject(String name) {
        return new MetaprojectImmutable(this.openBisService.tryGetMetaproject(name));
    }

    @Override
    public IMetaprojectAssignments getMetaprojectAssignments(String name) {
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignments assignments = this.openBisService.getMetaprojectAssignments(name);
        return new MetaprojectAssignments(assignments, this.openBisService);
    }

    @Override
    public List<IMetaprojectImmutable> listMetaprojectsForEntity(IMetaprojectContent entity) {
        List<Metaproject> metaprojects = this.openBisService.listMetaprojectsForEntity(entity.getEntityId());
        return ConversionUtils.convertToMetaprojectsImmutable(metaprojects);
    }

    @Override
    public IDataSetImmutable getDataSet(String dataSetCode) {
        AbstractExternalData dataSet = this.openBisService.tryGetDataSet(dataSetCode);
        if (dataSet == null) {
            return null;
        }
        return new DataSetImmutable(dataSet, this.openBisService);
    }

    @Override
    public IDataSetImmutable getThinDataSet(String dataSetCode) {
        AbstractExternalData dataSet = this.openBisService.tryGetThinDataSet(dataSetCode);
        if (dataSet == null) {
            return null;
        }
        return new DataSetImmutable(dataSet, this.openBisService);
    }

    @Override
    public IExperimentImmutable getExperiment(String experimentIdentifierString) {
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifierFactory(experimentIdentifierString).createIdentifier();
        Experiment experimentOrNull = this.openBisService.tryGetExperiment(experimentIdentifier);
        return experimentOrNull == null ? null : new ExperimentImmutable(experimentOrNull);
    }

    @Override
    public ISampleImmutable getSample(String sampleIdentifierString) {
        SampleIdentifier sampleIdentifier = new SampleIdentifierFactory(sampleIdentifierString).createIdentifier();
        Sample sampleOrNull = this.openBisService.tryGetSampleWithExperiment(sampleIdentifier);
        return sampleOrNull == null ? null : new SampleImmutable(sampleOrNull);
    }

    @Override
    public IMaterialImmutable getMaterial(String materialCode, String materialType) {
        MaterialIdentifier materialIdentifier = new MaterialIdentifier(materialCode, materialType);
        Material materialOrNull = this.openBisService.tryGetMaterial(materialIdentifier);
        return materialOrNull == null ? null : new MaterialImmutable(materialOrNull);
    }

    @Override
    public IMaterialImmutable getMaterial(String identifier) {
        MaterialIdentifier materialId = MaterialIdentifier.tryParseIdentifier(identifier);
        if (materialId == null) {
            throw new IllegalArgumentException("Incorrect material identifier format " + identifier + ". Expected code (type)");
        }
        return this.getMaterial(materialId.getCode(), materialId.getTypeCode());
    }
}

