/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.v2;

import ch.systemsx.cisd.etlserver.ITopLevelDataSetRegistratorDelegate;
import ch.systemsx.cisd.etlserver.registrator.IEntityOperationService;
import ch.systemsx.cisd.etlserver.registrator.v2.IOmniscientEntityRegistrator;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.AtomicEntityOperationDetails;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetRegistrationInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMetaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewProject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSpace;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationResult;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialUpdateDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpaceRoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyUpdatesDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultEntityOperationService<T extends DataSetInformation>
implements IEntityOperationService<T> {
    private final IOmniscientEntityRegistrator<T> registrator;
    private final ITopLevelDataSetRegistratorDelegate delegate;

    public DefaultEntityOperationService(IOmniscientEntityRegistrator<T> registrator, ITopLevelDataSetRegistratorDelegate delegate) {
        this.registrator = registrator;
        this.delegate = delegate;
    }

    @Override
    public AtomicEntityOperationResult performOperationsInApplicationServer(AtomicEntityOperationDetails<T> registrationDetails) {
        IEncapsulatedOpenBISService openBisService = this.registrator.getGlobalState().getOpenBisService();
        AtomicEntityOperationResult result = openBisService.performEntityOperations(this.convert(registrationDetails));
        ArrayList<DataSetInformation> registeredDataSets = new ArrayList<DataSetInformation>();
        for (DataSetRegistrationInformation<T> dsRegDetails : registrationDetails.getDataSetRegistrations()) {
            registeredDataSets.add((DataSetInformation)dsRegDetails.getDataSetInformation());
        }
        this.delegate.didRegisterDataSets(registeredDataSets);
        return result;
    }

    private ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationDetails convert(AtomicEntityOperationDetails<T> details) {
        List<NewSpace> spaceRegistrations = details.getSpaceRegistrations();
        List<NewProject> projectRegistrations = details.getProjectRegistrations();
        List<ProjectUpdatesDTO> projectUpdates = details.getProjectUpdates();
        List<NewExperiment> experimentRegistrations = details.getExperimentRegistrations();
        List<ExperimentUpdatesDTO> experimentUpdates = details.getExperimentUpdates();
        List<SampleUpdatesDTO> sampleUpdates = details.getSampleUpdates();
        List<NewSample> sampleRegistrations = details.getSampleRegistrations();
        Map<String, List<NewMaterial>> materialRegistrations = details.getMaterialRegistrations();
        List<MaterialUpdateDTO> materialUpdates = details.getMaterialUpdates();
        List<DataSetBatchUpdatesDTO> dataSetUpdates = details.getDataSetUpdates();
        List<NewMetaproject> metaprojectRegistrations = details.getMetaprojectRegistrations();
        List<MetaprojectUpdatesDTO> metaprojectUpdates = details.getMetaprojectUpdates();
        List<VocabularyUpdatesDTO> vocabularyUpdates = details.getVocabularyUpdates();
        List<SpaceRoleAssignment> spaceRoleAssignments = details.getSpaceRoleAssignments();
        List<SpaceRoleAssignment> spaceRoleRevocations = details.getSpaceRoleRevocations();
        ArrayList<NewExternalData> dataSetRegistrations = new ArrayList<NewExternalData>();
        for (DataSetRegistrationInformation<T> dsRegistration : details.getDataSetRegistrations()) {
            NewExternalData newExternalData = dsRegistration.getExternalData();
            dataSetRegistrations.add(newExternalData);
        }
        return new ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationDetails(details.getRegistrationId(), details.tryUserIdOrNull(), spaceRegistrations, projectRegistrations, projectUpdates, experimentRegistrations, experimentUpdates, sampleUpdates, sampleRegistrations, materialRegistrations, materialUpdates, dataSetRegistrations, dataSetUpdates, metaprojectRegistrations, metaprojectUpdates, vocabularyUpdates, spaceRoleAssignments, spaceRoleRevocations);
    }
}

