/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.archiveverifier.filesystem;

import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.IArchiveFileRepository;
import ch.systemsx.cisd.openbis.dss.archiveverifier.filesystem.IFileLocator;
import java.io.File;
import java.util.List;

public class FileSystemArchiveFileRepository
implements IArchiveFileRepository {
    private final List<File> archiveDirectories;
    private final IFileLocator fileLocator;

    public FileSystemArchiveFileRepository(List<File> archiveDirectories, IFileLocator fileLocator) {
        this.archiveDirectories = archiveDirectories;
        this.fileLocator = fileLocator;
    }

    @Override
    public File getArchiveFileOf(String dataSet) {
        for (File directory : this.archiveDirectories) {
            File file = this.fileLocator.getPathToArchiveOfDataSet(directory, dataSet);
            if (!file.exists()) continue;
            return file;
        }
        return new File("...");
    }
}

