/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.graph;

import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataTickUnit;
import java.io.Serializable;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;

public class TabularDataTickUnitSource
implements TickUnitSource,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double LOG_10_VALUE = Math.log(10.0);

    public TickUnit getLargerTickUnit(TickUnit unit) {
        double x = unit.getSize();
        return this.getCeilingTickUnit(x);
    }

    public TickUnit getCeilingTickUnit(TickUnit unit) {
        return this.getLargerTickUnit(unit);
    }

    public TickUnit getCeilingTickUnit(double size) {
        double numberOfDigits = Math.log(size) / LOG_10_VALUE;
        double higher = Math.ceil(numberOfDigits);
        double fullTickIncrement = Math.pow(10.0, higher);
        double halfTickIncrement = fullTickIncrement / 2.0;
        double tickIncrement = size <= halfTickIncrement ? halfTickIncrement : fullTickIncrement;
        return new TabularDataTickUnit(tickIncrement, Math.abs(higher), size >= 1.0);
    }
}

