/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IPluginScriptRunnerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.JythonBasedProcessingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.JythonBasedReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.MailService;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.PluginScriptRunnerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.api.IEmailSender;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.api.IMailService;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractTableModelReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ReportingBasedProcessingPlugin
implements IProcessingPluginTask {
    private static final long serialVersionUID = 1L;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, JythonBasedProcessingPlugin.class);
    private static final String EMAIL_SUBJECT = "email-subject";
    private static final String EMAIL_BODY = "email-body";
    private static final String ATTACHMENT_NAME = "attachment-name";
    private static final String SINGLE_REPORT = "single-report";
    private static final String DEFAULT_EMAIL_SUBJECT = MailService.DEFAULT_SUBJECT;
    private static final String DEFAULT_EMAIL_BODY = MailService.DEFAULT_BODY_TEXT;
    private static final String DEFAULT_ATTACHMENT_NAME = "report.txt";
    private static final boolean DEFAULT_SINGLE_REPORT_FOR_ALL = false;
    private final String emailSubject;
    private final String emailBody;
    private final String attachmentName;
    private final boolean singleReport;
    private final IPluginScriptRunnerFactory scriptRunnerFactory;

    protected static String getScriptPathProperty(Properties properties) {
        return JythonBasedProcessingPlugin.getScriptPathProperty(properties);
    }

    public ReportingBasedProcessingPlugin(Properties properties, File storeRoot) {
        this(new PluginScriptRunnerFactory(ReportingBasedProcessingPlugin.getScriptPathProperty(properties)), properties, storeRoot);
    }

    protected ReportingBasedProcessingPlugin(IPluginScriptRunnerFactory scriptRunnerFactory, Properties properties, File storeRoot) {
        this.scriptRunnerFactory = scriptRunnerFactory;
        this.singleReport = PropertyUtils.getBoolean(properties, SINGLE_REPORT, false);
        this.emailSubject = PropertyUtils.getProperty(properties, EMAIL_SUBJECT, DEFAULT_EMAIL_SUBJECT);
        this.emailBody = PropertyUtils.getProperty(properties, EMAIL_BODY, DEFAULT_EMAIL_BODY);
        this.attachmentName = PropertyUtils.getProperty(properties, ATTACHMENT_NAME, DEFAULT_ATTACHMENT_NAME);
    }

    @Override
    public ProcessingStatus process(List<DatasetDescription> dataSets, DataSetProcessingContext context) {
        MailService mailService = new MailService(context.getMailClient(), context.getUserEmailOrNull(), this.emailSubject, this.emailBody);
        ProcessingStatus status = new ProcessingStatus();
        if (this.singleReport) {
            try {
                this.createAndSendReport(dataSets, context, mailService);
                status.addDatasetStatuses(dataSets, Status.OK);
            }
            catch (Exception ex) {
                status.addDatasetStatuses(dataSets, Status.createError("Exception occured: " + ex));
                operationLog.error((Object)("Exception occured while processing " + dataSets), (Throwable)ex);
            }
        } else {
            for (DatasetDescription dataSet : dataSets) {
                try {
                    this.createAndSendReport(Collections.singletonList(dataSet), context, mailService);
                    status.addDatasetStatus(dataSet, Status.OK);
                }
                catch (Exception ex) {
                    status.addDatasetStatus(dataSet, Status.createError("Exception occured: " + ex));
                    operationLog.error((Object)("Exception occured while processing " + dataSet), (Throwable)ex);
                }
            }
        }
        return null;
    }

    private void createAndSendReport(List<DatasetDescription> dataSets, DataSetProcessingContext context, IMailService mailService) throws IOException {
        TableModel table = this.createTableModel(dataSets, context);
        String tableAsString = AbstractTableModelReportingPlugin.convertTableToCsvString(table);
        IEmailSender emailBuilder = mailService.createEmailSender().withAttachedText(tableAsString, this.attachmentName);
        emailBuilder.send();
    }

    public TableModel createTableModel(List<DatasetDescription> dataSets, DataSetProcessingContext context) {
        return JythonBasedReportingPlugin.createReport(dataSets, context, this.scriptRunnerFactory, ServiceProvider.getHierarchicalContentProvider());
    }
}

