/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.common.exceptions.ExceptionWithStatus;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.DefaultFileBasedHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IPathCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.ISshCommandExecutorFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.AbstractDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.ArchiveDestination;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.ArchiveDestinationFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DataSetFileOperationsManager
extends AbstractDataSetFileOperationsManager
implements IDataSetFileOperationsManager {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetFileOperationsManager.class);
    private final ArchiveDestination archiveDestination;

    public DataSetFileOperationsManager(Properties properties, IPathCopierFactory pathCopierFactory, ISshCommandExecutorFactory sshCommandExecutorFactory) {
        long timeoutInSeconds = PropertyUtils.getLong(properties, "timeout", 15L);
        long timeoutInMillis = timeoutInSeconds * 1000L;
        String hostFile = PropertyUtils.getMandatoryProperty(properties, "destination");
        ArchiveDestinationFactory factory = new ArchiveDestinationFactory(properties, pathCopierFactory, sshCommandExecutorFactory, hostFile, timeoutInMillis);
        this.archiveDestination = factory.createArchiveDestination();
    }

    @Override
    public Status copyToDestination(File originalData, DatasetDescription dataset) {
        try {
            File destinationFolder = new File(this.archiveDestination.getDestination(), dataset.getDataSetLocation());
            if (this.createFolderIfNotExists(destinationFolder.getParentFile()) || !this.destinationExists(destinationFolder).isSuccess()) {
                operationLog.info((Object)("Copy dataset '" + dataset.getDataSetCode() + "' from '" + originalData.getPath() + "' to '" + destinationFolder.getParentFile()));
                this.archiveDestination.getExecutor().copyDataSetToDestination(originalData, destinationFolder.getParentFile());
            } else {
                operationLog.info((Object)("Update dataset '" + dataset.getDataSetCode() + "' from '" + originalData.getPath() + "' to '" + destinationFolder.getParentFile()));
                this.archiveDestination.getExecutor().syncDataSetWithDestination(originalData, destinationFolder.getParentFile());
            }
            return Status.OK;
        }
        catch (ExceptionWithStatus ex) {
            return ex.getStatus();
        }
    }

    @Override
    public Status retrieveFromDestination(File originalData, DatasetDescription dataset) {
        try {
            File destinationFolder = new File(this.archiveDestination.getDestination(), dataset.getDataSetLocation());
            this.checkDestinationExists(destinationFolder);
            File folder = originalData.getParentFile();
            operationLog.info((Object)("Retrieve data set '" + dataset.getDataSetCode() + "' from '" + destinationFolder.getPath() + "' to '" + folder));
            folder.mkdirs();
            this.archiveDestination.getExecutor().retrieveDataSetFromDestination(folder, destinationFolder);
            return Status.OK;
        }
        catch (ExceptionWithStatus ex) {
            return ex.getStatus();
        }
    }

    @Override
    public Status deleteFromDestination(IDatasetLocation dataset) {
        return this.delete(dataset, new IDeleteAction(){

            @Override
            public String getName() {
                return "delete";
            }

            @Override
            public void delete(File dataSetFolder, String dataSetCode) {
                DataSetFileOperationsManager.this.archiveDestination.getExecutor().deleteFolder(dataSetFolder);
            }
        });
    }

    @Override
    public Status markAsDeleted(IDatasetLocation dataset) {
        return this.delete(dataset, new IDeleteAction(){

            @Override
            public String getName() {
                return "mark as deleted";
            }

            @Override
            public void delete(File dataSetFolder, String dataSetCode) {
                File deletedFolder = new File(DataSetFileOperationsManager.this.archiveDestination.getDestination(), "DELETED");
                DataSetFileOperationsManager.this.archiveDestination.getExecutor().createFolder(deletedFolder);
                File markerFile = new File(deletedFolder, dataSetCode);
                DataSetFileOperationsManager.this.archiveDestination.getExecutor().createMarkerFile(markerFile);
            }
        });
    }

    private Status delete(IDatasetLocation dataset, IDeleteAction action) {
        try {
            File destinationFolder = new File(this.archiveDestination.getDestination(), dataset.getDataSetLocation());
            BooleanStatus destinationExists = this.destinationExists(destinationFolder);
            if (destinationExists.isSuccess()) {
                action.delete(destinationFolder, dataset.getDataSetCode());
            } else {
                operationLog.info((Object)("Data of data set '" + dataset.getDataSetCode() + "' don't exist in the destination '" + destinationFolder.getPath() + "'. There is nothing to " + action.getName() + "."));
            }
            return Status.OK;
        }
        catch (ExceptionWithStatus ex) {
            return ex.getStatus();
        }
    }

    @Override
    public BooleanStatus isSynchronizedWithDestination(File originalData, DatasetDescription dataset) {
        try {
            File destinationFolder = new File(this.archiveDestination.getDestination(), dataset.getDataSetLocation());
            BooleanStatus resultStatus = this.archiveDestination.getExecutor().checkSame(originalData, destinationFolder);
            String message = resultStatus.tryGetMessage();
            if (message != null) {
                operationLog.error((Object)message);
            }
            return resultStatus;
        }
        catch (ExceptionWithStatus ex) {
            return BooleanStatus.createError(ex.getStatus().toString());
        }
    }

    @Override
    public BooleanStatus isPresentInDestination(DatasetDescription dataset) {
        try {
            File destinationFolder = new File(this.archiveDestination.getDestination(), dataset.getDataSetLocation());
            BooleanStatus resultStatus = this.archiveDestination.getExecutor().exists(destinationFolder);
            String message = resultStatus.tryGetMessage();
            if (message != null) {
                operationLog.error((Object)message);
            }
            return resultStatus;
        }
        catch (ExceptionWithStatus ex) {
            return BooleanStatus.createError(ex.getStatus().toString());
        }
    }

    private void checkDestinationExists(File destinationFolder) {
        BooleanStatus destinationExists = this.destinationExists(destinationFolder);
        if (!destinationExists.isSuccess()) {
            operationLog.error((Object)("Destination folder '" + destinationFolder + "' doesn't exist"));
            throw new ExceptionWithStatus(Status.createError("destination doesn't exist"));
        }
    }

    private boolean createFolderIfNotExists(File destinationFolder) {
        BooleanStatus destinationExists = this.destinationExists(destinationFolder);
        if (!destinationExists.isSuccess()) {
            this.archiveDestination.getExecutor().createFolder(destinationFolder);
            return true;
        }
        return false;
    }

    private BooleanStatus destinationExists(File destinationFolder) {
        BooleanStatus destinationExists = this.archiveDestination.getExecutor().exists(destinationFolder);
        if (destinationExists.isError()) {
            operationLog.error((Object)("Could not check existence of '" + destinationFolder + "': " + destinationExists.tryGetMessage()));
            throw new ExceptionWithStatus(Status.createError("couldn't check existence"));
        }
        return destinationExists;
    }

    @Override
    public boolean isHosted() {
        return this.archiveDestination.isHosted();
    }

    @Override
    public IHierarchicalContent getAsHierarchicalContent(DatasetDescription dataset) {
        return new DefaultFileBasedHierarchicalContentFactory().asHierarchicalContent(new File(this.archiveDestination.getDestination(), dataset.getDataSetLocation()), null);
    }

    private static interface IDeleteAction {
        public String getName();

        public void delete(File var1, String var2);
    }
}

