/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver;

import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.HostAwareFile;
import ch.systemsx.cisd.common.filesystem.IPathCopier;
import ch.systemsx.cisd.common.filesystem.highwatermark.HostAwareFileWithHighwaterMark;
import ch.systemsx.cisd.common.filesystem.ssh.ISshCommandExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetFileOperationsExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.LocalDataSetFileOperationsExcecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.RemoteDataSetFileOperationsExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.Copier;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IPathCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.ISshCommandExecutorFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.ArchiveDestination;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;

public class ArchiveDestinationFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Properties properties;
    private final IPathCopierFactory pathCopierFactory;
    private final ISshCommandExecutorFactory sshCommandExecutorFactory;
    private final String archiveDestinationHost;
    private final long timeoutInMillis;

    public ArchiveDestinationFactory(Properties properties, IPathCopierFactory pathCopierFactory, ISshCommandExecutorFactory sshCommandExecutorFactory, String archiveDestinationHost, long timeoutInMillis) {
        this.properties = properties;
        this.pathCopierFactory = pathCopierFactory;
        this.sshCommandExecutorFactory = sshCommandExecutorFactory;
        this.archiveDestinationHost = archiveDestinationHost;
        this.timeoutInMillis = timeoutInMillis;
    }

    public ArchiveDestination createArchiveDestination() {
        HostAwareFileWithHighwaterMark hostAwareFile = HostAwareFileWithHighwaterMark.create(this.archiveDestinationHost, -1L);
        boolean isHosted = hostAwareFile.tryGetHost() != null;
        String destination = hostAwareFile.getPath();
        IDataSetFileOperationsExecutor executor = !isHosted ? ArchiveDestinationFactory.createLocalDataSetFileOperationsExecutor(this.properties, this.pathCopierFactory, hostAwareFile, this.timeoutInMillis) : ArchiveDestinationFactory.createRemoteDataSetFileOperationsExecutor(this.properties, this.pathCopierFactory, this.sshCommandExecutorFactory, hostAwareFile, this.timeoutInMillis);
        return new ArchiveDestination(destination, executor, isHosted, this.timeoutInMillis);
    }

    private static RemoteDataSetFileOperationsExecutor createRemoteDataSetFileOperationsExecutor(Properties properties, IPathCopierFactory pathCopierFactory, ISshCommandExecutorFactory sshCommandExecutorFactory, HostAwareFile hostAwareFile, long timeoutInMillis) {
        String hostOrNull = hostAwareFile.tryGetHost();
        File sshExecutable = Copier.getExecutable(properties, "ssh");
        File rsyncExecutable = Copier.getExecutable(properties, "rsync");
        File gfindExecutable = Copier.getExecutable(properties, "find");
        IPathCopier copier = pathCopierFactory.create(rsyncExecutable, sshExecutable, timeoutInMillis);
        copier.check();
        String rsyncModule = hostAwareFile.tryGetRsyncModule();
        String rsyncPasswordFile = properties.getProperty("rsync-password-file");
        FileUtilities.checkPathCopier(copier, hostOrNull, null, rsyncModule, rsyncPasswordFile, timeoutInMillis);
        ISshCommandExecutor sshCommandExecutor = sshCommandExecutorFactory.create(sshExecutable, hostOrNull);
        RemoteDataSetFileOperationsExecutor result = new RemoteDataSetFileOperationsExecutor(sshCommandExecutor, copier, gfindExecutable, hostOrNull, rsyncModule, rsyncPasswordFile, timeoutInMillis);
        return result;
    }

    private static LocalDataSetFileOperationsExcecutor createLocalDataSetFileOperationsExecutor(Properties properties, IPathCopierFactory pathCopierFactory, HostAwareFile hostAwareFile, long timeoutInMillis) {
        File sshExecutable = null;
        File rsyncExecutable = Copier.getExecutable(properties, "rsync");
        IPathCopier copier = pathCopierFactory.create(rsyncExecutable, sshExecutable, timeoutInMillis);
        copier.check();
        String rsyncModule = hostAwareFile.tryGetRsyncModule();
        String rsyncPasswordFile = properties.getProperty("rsync-password-file");
        LocalDataSetFileOperationsExcecutor result = new LocalDataSetFileOperationsExcecutor(FileOperations.getMonitoredInstanceForCurrentThread(), copier, rsyncModule, rsyncPasswordFile);
        return result;
    }
}

