/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.tar.Untar;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.TarPackageManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.IMultiDataSetPackageManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class MultiDataSetPackageManager
extends TarPackageManager
implements IMultiDataSetPackageManager {
    public MultiDataSetPackageManager(Properties properties, ISimpleLogger ioSpeedLogger) {
        super(properties, ioSpeedLogger);
    }

    @Override
    public Status extractMultiDataSets(File packageFile, HashMap<String, File> dataSetCodeToDirectory) {
        Untar untar = null;
        try {
            untar = new Untar(packageFile);
            untar.extract(dataSetCodeToDirectory);
            for (File location : dataSetCodeToDirectory.values()) {
                File metadataFile = new File(location, "meta-data.tsv");
                if (!metadataFile.exists() || !metadataFile.isFile()) continue;
                FileUtilities.delete(metadataFile);
            }
            Status status = Status.OK;
            return status;
        }
        catch (Exception ex) {
            Status status = Status.createError(ex.toString());
            return status;
        }
        finally {
            if (untar != null) {
                try {
                    untar.close();
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                }
            }
        }
    }
}

