/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess;

import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.IMultiDataSetArchiverDBTransaction;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.IMultiDataSetArchiverQueryDAO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverContainerDTO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver.dataaccess.MultiDataSetArchiverDataSourceUtil;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.util.List;

public class MultiDataSetArchiverDBTransaction
implements IMultiDataSetArchiverDBTransaction {
    private IMultiDataSetArchiverQueryDAO transaction = MultiDataSetArchiverDataSourceUtil.getTransactionalQuery();

    @Override
    public List<MultiDataSetArchiverDataSetDTO> getDataSetsForContainer(MultiDataSetArchiverContainerDTO container) {
        return this.transaction.listDataSetsForContainerId(container.getId());
    }

    @Override
    public MultiDataSetArchiverContainerDTO createContainer(String path) {
        MultiDataSetArchiverContainerDTO container = new MultiDataSetArchiverContainerDTO(0L, path);
        long id = this.transaction.addContainer(container);
        container.setId(id);
        return container;
    }

    @Override
    public void deleteContainer(String container) {
        this.transaction.deleteContainer(container);
    }

    @Override
    public MultiDataSetArchiverDataSetDTO insertDataset(DatasetDescription dataSet, MultiDataSetArchiverContainerDTO container) {
        String code = dataSet.getDataSetCode();
        MultiDataSetArchiverDataSetDTO mads = this.getDataSetForCode(code);
        if (mads != null) {
            throw new IllegalStateException("Dataset " + dataSet.getDataSetCode() + "is already archived in other container");
        }
        mads = new MultiDataSetArchiverDataSetDTO(0L, code, container.getId(), dataSet.getDataSetSize());
        long id = this.transaction.addDataSet(mads);
        mads.setId(id);
        return mads;
    }

    @Override
    public MultiDataSetArchiverDataSetDTO getDataSetForCode(String code) {
        return this.transaction.getDataSetForCode(code);
    }

    @Override
    public void requestUnarchiving(List<String> dataSetCodes) {
        this.transaction.requestUnarchiving(dataSetCodes.toArray(new String[dataSetCodes.size()]));
    }

    @Override
    public void resetRequestUnarchiving(long containerId) {
        this.transaction.resetRequestUnarchiving(containerId);
    }

    @Override
    public void commit() {
        this.transaction.commit();
    }

    @Override
    public void rollback() {
        this.transaction.rollback();
    }

    @Override
    public void close() {
        this.transaction.close();
    }
}

