/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import java.io.File;

public class DataSetDirectoryProvider
implements IDataSetDirectoryProvider {
    private final File storeRoot;
    private final IShareIdManager shareIdManager;

    public DataSetDirectoryProvider(File storeRoot, IShareIdManager shareIdManager) {
        this.storeRoot = storeRoot;
        this.shareIdManager = shareIdManager;
    }

    @Override
    public File getStoreRoot() {
        return this.storeRoot;
    }

    @Override
    public File getDataSetDirectory(IDatasetLocation dataSet) {
        String shareId = this.shareIdManager.getShareId(dataSet.getDataSetCode());
        String location = dataSet.getDataSetLocation();
        return this.getDataSetDirectory(shareId, location);
    }

    @Override
    public File getDataSetDirectory(String shareId, String location) {
        String loc = location.replace("\\", File.separator);
        File share = new File(this.storeRoot, shareId);
        return new File(share, loc);
    }

    @Override
    public IShareIdManager getShareIdManager() {
        return this.shareIdManager;
    }
}

