/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.ArchiveFolders;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import com.csvreader.CsvReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IdentifierAttributeMappingManager {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, IdentifierAttributeMappingManager.class);
    private final Map<String, Attributes> attributesMap = new HashMap<String, Attributes>();
    private final boolean createArchives;
    private final File mappingFileOrNull;
    private long mappingFileLastModified;
    private Long smallDataSetsSizeLimit;

    public IdentifierAttributeMappingManager(String mappingFilePathOrNull, boolean createArchives, Long smallDataSetsSizeLimit) {
        this.createArchives = createArchives;
        this.smallDataSetsSizeLimit = smallDataSetsSizeLimit;
        if (StringUtils.isBlank((String)mappingFilePathOrNull)) {
            this.mappingFileOrNull = null;
        } else {
            this.mappingFileOrNull = new File(mappingFilePathOrNull);
            if (!this.mappingFileOrNull.exists()) {
                throw new IllegalArgumentException("Mapping file '" + this.mappingFileOrNull + "' does not exist.");
            }
            this.getAttributesMap();
        }
    }

    private Map<String, Attributes> getAttributesMap() {
        long lastModified;
        if (this.mappingFileOrNull != null && (lastModified = this.mappingFileOrNull.lastModified()) != this.mappingFileLastModified) {
            this.loadMappingFile(this.mappingFileOrNull);
            this.mappingFileLastModified = lastModified;
        }
        return this.attributesMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadMappingFile(File mappingFile) {
        CsvReader reader = null;
        try {
            try {
                reader = new CsvReader(mappingFile.getPath(), '\t');
                reader.setSkipEmptyRecords(true);
                reader.setUseComments(false);
                reader.setComment('#');
                reader.setTrimWhitespace(true);
                boolean success = reader.readHeaders();
                if (!success) {
                    throw new IllegalArgumentException("Empty mapping file: " + mappingFile);
                }
                while (true) {
                    if (!reader.readRecord()) {
                        operationLog.info((Object)("Mapping file '" + mappingFile + "' successfully loaded."));
                        return;
                    }
                    String[] row = reader.getValues();
                    if (this.isEmptyRow(row)) continue;
                    if (row.length != 3) {
                        throw new IllegalArgumentException("Invalid number of row elements in mapping file '" + mappingFile + "': " + Arrays.asList(row));
                    }
                    String identifier = row[0].toUpperCase();
                    String shareID = row[1];
                    if (StringUtils.isBlank((String)shareID)) {
                        shareID = null;
                    }
                    List<String> shareIds = this.getShareIds(identifier, row);
                    ArchiveFolders archiveFolders = this.getArchiveFolders(identifier, row);
                    this.attributesMap.put(identifier, new Attributes(shareIds, archiveFolders));
                }
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private boolean isEmptyRow(String[] row) {
        String[] stringArray = row;
        int n = row.length;
        int n2 = 0;
        while (n2 < n) {
            String cell = stringArray[n2];
            if (cell.length() > 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private ArchiveFolders getArchiveFolders(String identifier, String[] row) {
        if (StringUtils.isBlank((String)row[2])) {
            return null;
        }
        String[] folderPaths = row[2].split(",");
        return ArchiveFolders.create(folderPaths, this.createArchives, this.smallDataSetsSizeLimit);
    }

    private List<String> getShareIds(String identifier, String[] row) {
        String[] splittedIds;
        String idsAttribute = row[1];
        ArrayList<String> ids = new ArrayList<String>();
        if (StringUtils.isBlank((String)idsAttribute)) {
            return ids;
        }
        String[] stringArray = splittedIds = idsAttribute.split(",");
        int n = splittedIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            ids.add(id.trim());
            ++n2;
        }
        return ids;
    }

    public Collection<File> getAllFolders() {
        HashSet<File> folders = new HashSet<File>();
        for (Attributes attributes : this.getAttributesMap().values()) {
            ArchiveFolders archiveFolders = attributes.getArchiveFolders();
            if (archiveFolders == null) continue;
            for (File archiveFolder : archiveFolders.getAllFolders()) {
                if (archiveFolder == null || !archiveFolder.exists()) continue;
                folders.add(archiveFolder);
            }
        }
        return folders;
    }

    public File getArchiveFolder(DatasetDescription dataSetDescription, File defaultFolder) {
        String experimentCode;
        String projectCode;
        String spaceCode = dataSetDescription.getSpaceCode();
        Attributes attributes = this.tryGetExperimentAttributes(spaceCode, projectCode = dataSetDescription.getProjectCode(), experimentCode = dataSetDescription.getExperimentCode());
        if (this.hasArchiveFolder(dataSetDescription, attributes)) {
            return attributes.getArchiveFolders().getFolder(dataSetDescription);
        }
        attributes = this.tryGetProjectAttributes(spaceCode, projectCode);
        if (this.hasArchiveFolder(dataSetDescription, attributes)) {
            return attributes.getArchiveFolders().getFolder(dataSetDescription);
        }
        attributes = this.tryGetSpaceAttributes(spaceCode);
        if (this.hasArchiveFolder(dataSetDescription, attributes)) {
            return attributes.getArchiveFolders().getFolder(dataSetDescription);
        }
        return defaultFolder;
    }

    private boolean hasArchiveFolder(DatasetDescription dataSetDescription, Attributes attributes) {
        return attributes != null && attributes.getArchiveFolders() != null && attributes.getArchiveFolders().getFolder(dataSetDescription) != null;
    }

    public List<String> getShareIds(SimpleDataSetInformationDTO dataSet) {
        String experimentCode;
        String projectCode;
        String spaceCode = dataSet.getSpaceCode();
        Attributes attributes = this.tryGetExperimentAttributes(spaceCode, projectCode = dataSet.getProjectCode(), experimentCode = dataSet.getExperimentCode());
        if (this.hasShareIds(attributes)) {
            return attributes.getShareIds();
        }
        attributes = this.tryGetProjectAttributes(spaceCode, projectCode);
        if (this.hasShareIds(attributes)) {
            return attributes.getShareIds();
        }
        attributes = this.tryGetSpaceAttributes(spaceCode);
        if (this.hasShareIds(attributes)) {
            return attributes.getShareIds();
        }
        return Collections.emptyList();
    }

    private boolean hasShareIds(Attributes attributes) {
        if (attributes == null) {
            return false;
        }
        List<String> shareIds = attributes.getShareIds();
        return shareIds != null && !shareIds.isEmpty();
    }

    private Attributes tryGetExperimentAttributes(String spaceCode, String projectCode, String experimentCode) {
        String identifier = new ExperimentIdentifier(null, spaceCode, projectCode, experimentCode).toString();
        return this.getAttributesMap().get(identifier);
    }

    private Attributes tryGetProjectAttributes(String spaceCode, String projectCode) {
        String identifier = new ProjectIdentifier(null, spaceCode, projectCode).toString();
        return this.getAttributesMap().get(identifier);
    }

    private Attributes tryGetSpaceAttributes(String spaceCode) {
        return this.getAttributesMap().get(new SpaceIdentifier(spaceCode).toString());
    }

    private static final class Attributes {
        private final ArchiveFolders archiveFolders;
        private final List<String> shareIds;

        Attributes(List<String> shareIds, ArchiveFolders archiveFolders) {
            this.shareIds = shareIds;
            this.archiveFolders = archiveFolders;
        }

        public List<String> getShareIds() {
            return this.shareIds;
        }

        public ArchiveFolders getArchiveFolders() {
            return this.archiveFolders;
        }
    }
}

