/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.DisposableTabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.managed_property.ManagedPropertyGridGeneratedCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableModelReference;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IManagedPropertyGridInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedHtmlWidgetDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedTableWidgetDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedOutputWidgetDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedUiDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.ManagedOutputWidgetType;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Set;

public class ManagedPropertySection
extends DisposableTabContent {
    private static final IDisposableComponent DUMMY_CONTENT = new IDisposableComponent(){

        @Override
        public void update(Set<DatabaseModificationKind> observedModifications) {
        }

        @Override
        public DatabaseModificationKind[] getRelevantModifications() {
            return DatabaseModificationKind.EMPTY_ARRAY;
        }

        @Override
        public Component getComponent() {
            return new ContentPanel();
        }

        @Override
        public void dispose() {
        }
    };
    private static String ID_PREFIX = "managed_property_section_";
    private final String gridIdSuffix;
    private final IDelegatedAction refreshAction;
    private final Button refreshButton;
    private final IManagedProperty managedProperty;
    private final IEntityInformationHolder entity;

    public ManagedPropertySection(String header, IViewContext<?> viewContext, IEntityInformationHolder entity, IManagedProperty managedProperty, IDelegatedAction refreshAction) {
        super(header, viewContext, entity);
        this.entity = entity;
        this.managedProperty = managedProperty;
        this.gridIdSuffix = managedProperty.getPropertyTypeCode();
        this.refreshAction = refreshAction;
        this.refreshButton = ManagedPropertySection.createRefreshButton(viewContext, refreshAction);
        this.setIds(new IDisplayTypeIDGenerator(){

            @Override
            public String createID(String suffix) {
                return String.valueOf(this.createID()) + suffix;
            }

            @Override
            public String createID() {
                return String.valueOf(ID_PREFIX) + ManagedPropertySection.this.gridIdSuffix;
            }
        });
    }

    private static Button createRefreshButton(IMessageProvider messageProvider, final IDelegatedAction refreshAction) {
        Button button = new Button(messageProvider.getMessage("button_refresh", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                if (ce.getButton().isEnabled()) {
                    refreshAction.execute();
                }
            }
        });
        return button;
    }

    @Override
    protected IDisposableComponent createDisposableContent() {
        if (this.managedProperty == null || this.managedProperty.getUiDescription() == null || this.managedProperty.getUiDescription().getOutputWidgetDescription() == null) {
            return null;
        }
        ManagedOutputWidgetType type = this.managedProperty.getUiDescription().getOutputWidgetDescription().getManagedOutputWidgetType();
        if (type == ManagedOutputWidgetType.HTML) {
            return this.createDisposableHtmlContent();
        }
        return this.createDisposableTableModelContent();
    }

    private IDisposableComponent createDisposableHtmlContent() {
        try {
            final Html htmlComponent = this.extractHtmlComponent();
            return new IDisposableComponent(){

                @Override
                public void update(Set<DatabaseModificationKind> observedModifications) {
                }

                @Override
                public DatabaseModificationKind[] getRelevantModifications() {
                    return DatabaseModificationKind.EMPTY_ARRAY;
                }

                @Override
                public Component getComponent() {
                    return htmlComponent;
                }

                @Override
                public void dispose() {
                }
            };
        }
        catch (UserFailureException ex) {
            String basicMsg = ex.getMessage();
            String detailedMsg = ex.getDetails();
            if (detailedMsg != null) {
                GWTUtils.createErrorMessageWithDetailsDialog(this.viewContext, basicMsg, detailedMsg).show();
            } else {
                MessageBox.alert((String)"Error", (String)basicMsg, null);
            }
            return DUMMY_CONTENT;
        }
    }

    private IDisposableComponent createDisposableTableModelContent() {
        try {
            TableModel tableModel = this.extractTableModel();
            IManagedPropertyGridInformationProvider gridInfo = new IManagedPropertyGridInformationProvider(){

                @Override
                public String getKey() {
                    return ManagedPropertySection.this.gridIdSuffix;
                }
            };
            ManagedPropertyGridGeneratedCallback.IOnGridComponentGeneratedAction gridGeneratedAction = new ManagedPropertyGridGeneratedCallback.IOnGridComponentGeneratedAction(){

                @Override
                public void execute(IDisposableComponent gridComponent) {
                    ManagedPropertySection.this.replaceContent(gridComponent);
                }
            };
            AsyncCallback<TableModelReference> callback = ManagedPropertyGridGeneratedCallback.create(this.viewContext.getCommonViewContext(), this.entity, this.managedProperty, gridInfo, gridGeneratedAction, this.refreshAction);
            this.viewContext.getCommonService().createReportFromTableModel(tableModel, callback);
            return null;
        }
        catch (UserFailureException ex) {
            String basicMsg = ex.getMessage();
            String detailedMsg = ex.getDetails();
            if (detailedMsg != null) {
                GWTUtils.createErrorMessageWithDetailsDialog(this.viewContext, basicMsg, detailedMsg).show();
            } else {
                MessageBox.alert((String)"Error", (String)basicMsg, null);
            }
            return DUMMY_CONTENT;
        }
    }

    private TableModel extractTableModel() throws UserFailureException {
        IManagedOutputWidgetDescription outputWidget;
        IManagedUiDescription uiDescription = this.managedProperty.getUiDescription();
        if (uiDescription == null) {
            this.throwFailToCreateContentException("UiDescription was not set in IManagedProperty object");
            return null;
        }
        String value = StringEscapeUtils.unescapeHtml(this.managedProperty.getValue());
        if (value.startsWith(BasicConstant.ERROR_PROPERTY_PREFIX) && !value.equals(BasicConstant.MANAGED_PROPERTY_PLACEHOLDER_VALUE)) {
            this.getHeader().addTool((Component)this.refreshButton);
            String errorMsg = value.substring(BasicConstant.ERROR_PROPERTY_PREFIX.length());
            this.throwFailToCreateContentException(errorMsg);
        }
        if ((outputWidget = uiDescription.getOutputWidgetDescription()) == null) {
            this.throwFailToCreateContentException("Output widget was not set in IManagedUiDescription object");
        } else if (outputWidget.getManagedOutputWidgetType() != ManagedOutputWidgetType.TABLE) {
            this.throwFailToCreateContentException("IManagedOutputWidgetDescription is not of type ManagedOutputWidgetType.TABLE");
        } else if (!(outputWidget instanceof ManagedTableWidgetDescription)) {
            this.throwFailToCreateContentException("IManagedOutputWidgetDescription should be a subclass of ManagedTableWidgetDescription");
        }
        ManagedTableWidgetDescription tableDescription = (ManagedTableWidgetDescription)uiDescription.getOutputWidgetDescription();
        TableModel result = tableDescription.getTableModel();
        if (tableDescription.getTableModel() == null) {
            this.throwFailToCreateContentException("TableModel was not set in ManagedTableWidgetDescription object");
        }
        return result;
    }

    private Html extractHtmlComponent() throws UserFailureException {
        IManagedOutputWidgetDescription outputWidget;
        IManagedUiDescription uiDescription = this.managedProperty.getUiDescription();
        if (uiDescription == null) {
            this.throwFailToCreateContentException("UiDescription was not set in IManagedProperty object");
            return null;
        }
        String value = StringEscapeUtils.unescapeHtml(this.managedProperty.getValue());
        if (value.startsWith(BasicConstant.ERROR_PROPERTY_PREFIX) && !value.equals(BasicConstant.MANAGED_PROPERTY_PLACEHOLDER_VALUE)) {
            this.getHeader().addTool((Component)this.refreshButton);
            String errorMsg = value.substring(BasicConstant.ERROR_PROPERTY_PREFIX.length());
            this.throwFailToCreateContentException(errorMsg);
        }
        if ((outputWidget = uiDescription.getOutputWidgetDescription()) == null) {
            this.throwFailToCreateContentException("Output widget was not set in IManagedUiDescription object");
        } else if (outputWidget.getManagedOutputWidgetType() != ManagedOutputWidgetType.HTML) {
            this.throwFailToCreateContentException("IManagedOutputWidgetDescription is not of type ManagedOutputWidgetType.MULTILINE_TEXT");
        } else if (!(outputWidget instanceof ManagedHtmlWidgetDescription)) {
            this.throwFailToCreateContentException("IManagedOutputWidgetDescription should be a subclass of ManagedMultilineTextWidgetDescription");
        }
        ManagedHtmlWidgetDescription htmlDescription = (ManagedHtmlWidgetDescription)uiDescription.getOutputWidgetDescription();
        String htmlValue = StringEscapeUtils.unescapeHtml(htmlDescription.getHtml());
        return new Html(htmlValue);
    }

    private void throwFailToCreateContentException(String detailedErrorMsg) throws UserFailureException {
        throw new UserFailureException("Failed to create content for " + this.getHeading() + ".", detailedErrorMsg);
    }
}

