/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.framework;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LastModificationState;
import java.util.HashSet;
import java.util.Set;

class LastModificationStateUpdater
extends AbstractAsyncCallback<LastModificationState> {
    private final ICommonClientServiceAsync commonService;
    private LastModificationState lastSeenModificationStateOrNull;
    private final IDatabaseModificationObserver modificationObserver;

    public LastModificationStateUpdater(IViewContext<?> viewContext, IDatabaseModificationObserver modificationObserver) {
        super(viewContext, false);
        this.commonService = viewContext.getCommonService();
        this.modificationObserver = modificationObserver;
        this.lastSeenModificationStateOrNull = null;
        this.ignore();
    }

    public void update() {
        this.reuse();
        this.commonService.getLastModificationState(this);
    }

    @Override
    protected void process(LastModificationState freshState) {
        this.refreshIfNecessary(freshState);
        this.updateState(freshState);
    }

    private void refreshIfNecessary(LastModificationState freshState) {
        if (this.lastSeenModificationStateOrNull == null) {
            return;
        }
        DatabaseModificationKind[] relevantModifications = this.modificationObserver.getRelevantModifications();
        Set<DatabaseModificationKind> unseenModifications = LastModificationStateUpdater.extractUnseenModifications(relevantModifications, freshState, this.lastSeenModificationStateOrNull);
        if (unseenModifications.size() > 0) {
            this.modificationObserver.update(unseenModifications);
        }
    }

    private static Set<DatabaseModificationKind> extractUnseenModifications(DatabaseModificationKind[] relevantModifications, LastModificationState freshState, LastModificationState lastSeenModificationState) {
        HashSet<DatabaseModificationKind> unseenModifications = new HashSet<DatabaseModificationKind>();
        DatabaseModificationKind[] databaseModificationKindArray = relevantModifications;
        int n = relevantModifications.length;
        int n2 = 0;
        while (n2 < n) {
            long lastModification;
            DatabaseModificationKind modification = databaseModificationKindArray[n2];
            long lastSeen = lastSeenModificationState.getLastModificationTime(modification);
            if (lastSeen < (lastModification = freshState.getLastModificationTime(modification))) {
                unseenModifications.add(modification);
            }
            ++n2;
        }
        return unseenModifications;
    }

    private void updateState(LastModificationState freshState) {
        this.lastSeenModificationStateOrNull = freshState;
    }
}

