/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.ComputationData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.IComputationAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.SelectedOrAllDataSetsRadioProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DialogWithOnlineHelpUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

class PerformComputationDialog
extends AbstractDataConfirmationDialog<ComputationData> {
    private static final int LABEL_WIDTH = 80;
    private static final int FIELD_WIDTH = 180;
    private static final int DIALOG_WIDTH = 430;
    private static final String BR = "<br/>";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private List<String> selectedDataSetTypeCodes;
    private final SelectedOrAllDataSetsRadioProvider radioProvider;
    private final DatastoreServiceDescription pluginTask;
    private Html selectedDataSetTypesText;

    protected PerformComputationDialog(IViewContext<ICommonClientServiceAsync> viewContext, ComputationData data, String title) {
        super(viewContext, data, title);
        this.viewContext = viewContext;
        this.pluginTask = data.getService();
        this.radioProvider = new SelectedOrAllDataSetsRadioProvider(data);
        this.setWidth(430);
        DialogWithOnlineHelpUtils.addHelpButton(viewContext, (Window)this, this.createHelpPageIdentifier());
    }

    @Override
    protected void initializeData() {
        super.initializeData();
        Set<DataSetType> selectedDataSetTypes = this.getSelectedDataSetTypes();
        this.selectedDataSetTypeCodes = new ArrayList<String>(selectedDataSetTypes.size());
        for (DataSetType type : selectedDataSetTypes) {
            this.selectedDataSetTypeCodes.add(type.getCode());
        }
    }

    private Set<DataSetType> getSelectedDataSetTypes() {
        TreeSet<DataSetType> result = new TreeSet<DataSetType>();
        for (AbstractExternalData dataSet : ((ComputationData)this.data).getSelectedDataSets()) {
            result.add(dataSet.getDataSetType());
        }
        return result;
    }

    @Override
    protected String createMessage() {
        int size = ((ComputationData)this.data).getSelectedDataSets().size();
        String computationName = this.pluginTask.getLabel();
        if (size == 0) {
            String msgIntroduction = this.viewContext.getMessage("no_datasets_selected", new Object[0]);
            return this.viewContext.getMessage("perform_computation_on_all_datasets_msg_template", msgIntroduction, computationName);
        }
        return this.viewContext.getMessage("perform_computation_on_selected_or_all_datasets_msg_template", computationName, size);
    }

    @Override
    protected boolean validate() {
        boolean computeOnSelected = this.getComputeOnSelected();
        if (computeOnSelected) {
            Set<String> supportedDataSetTypes = this.getSupportedDataSetTypes(this.pluginTask);
            ArrayList<String> unsupportedDataSetTypes = new ArrayList<String>();
            for (String selectedDataSetType : this.selectedDataSetTypeCodes) {
                if (supportedDataSetTypes.contains(selectedDataSetType)) continue;
                unsupportedDataSetTypes.add(selectedDataSetType);
            }
            if (unsupportedDataSetTypes.size() > 0) {
                String msg = this.createUnsupportedDataSetTypesText(unsupportedDataSetTypes);
                MessageBox.alert((String)"Error", (String)msg, null);
                return false;
            }
        }
        return super.validate();
    }

    @Override
    protected void executeConfirmedAction() {
        IComputationAction computationAction = ((ComputationData)this.data).getComputationAction();
        boolean computeOnSelected = this.getComputeOnSelected();
        computationAction.execute(this.pluginTask, computeOnSelected);
    }

    private Set<String> getSupportedDataSetTypes(DatastoreServiceDescription plugin) {
        return new HashSet<String>(Arrays.asList(plugin.getDatasetTypeCodes()));
    }

    @Override
    protected void extendForm() {
        this.formPanel.setLabelWidth(80);
        this.formPanel.setFieldWidth(180);
        if (((ComputationData)this.data).getSelectedDataSets().size() > 0) {
            this.formPanel.add((Widget)this.createComputationDataSetsRadio());
            this.selectedDataSetTypesText = this.formPanel.addText(this.createSelectedDataSetTypeText());
            this.updateComputationDataSetsState();
        }
        Button confirmButton = this.getButtonById("ok");
        confirmButton.setText("Run");
    }

    private final String createSelectedDataSetTypeText() {
        return this.createDataSetTypeMsg("Types of selected Data Sets", this.selectedDataSetTypeCodes);
    }

    private final String createUnsupportedDataSetTypesText(List<String> dataSetTypes) {
        return this.createDataSetTypeMsg("Selected service does not support all types of selected Data Sets. <br/><br/>Unsupported Data Set types", dataSetTypes);
    }

    private final String createDataSetTypeMsg(String msgPrefix, List<String> dataSetTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(msgPrefix);
        sb.append(": ");
        sb.append(StringUtils.joinList(dataSetTypes));
        return sb.toString();
    }

    private final RadioGroup createComputationDataSetsRadio() {
        return this.radioProvider.createComputationDataSetsRadio();
    }

    private boolean getComputeOnSelected() {
        return this.radioProvider.getComputeOnSelected();
    }

    private final void updateComputationDataSetsState() {
        boolean showSelectedDataSetTypes = this.getComputeOnSelected();
        this.selectedDataSetTypesText.setVisible(showSelectedDataSetTypes);
    }

    private HelpPageIdentifier createHelpPageIdentifier() {
        return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.PERFORM_COMPUTATION, HelpPageIdentifier.HelpPageAction.ACTION);
    }
}

