/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field;

import ch.systemsx.cisd.common.shared.basic.string.IgnoreCaseComparator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MultilineItemsField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class MetaprojectArea
extends MultilineItemsField {
    public static final String ID_SUFFIX = "_metaprojects";

    public MetaprojectArea(IMessageProvider messageProvider, String idPrefix) {
        super("", false);
        this.setFieldLabel(messageProvider.getMessage("metaprojects", new Object[0]));
        this.setEmptyText(messageProvider.getMessage("metaprojects_hint", new Object[0]));
        this.setId(String.valueOf(idPrefix) + ID_SUFFIX);
    }

    public void setMetaprojects(Collection<Metaproject> metaprojects) {
        ArrayList<String> names = new ArrayList<String>();
        if (metaprojects != null) {
            for (Metaproject metaproject : metaprojects) {
                names.add(metaproject.getName());
            }
        }
        Collections.sort(names, new IgnoreCaseComparator());
        this.setItems(names);
    }

    public final String[] tryGetMetaprojects() {
        return this.getNotEmptyItems(this.getItems());
    }

    public final String[] tryGetModifiedMetaprojects() {
        return this.getNotEmptyItems(this.tryGetModifiedItemList());
    }

    private String[] getNotEmptyItems(String[] items) {
        if (items != null) {
            ArrayList<String> notEmptyItems = new ArrayList<String>();
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item != null && item.trim().length() > 0) {
                    notEmptyItems.add(item.trim());
                }
                ++n2;
            }
            return notEmptyItems.toArray(new String[notEmptyItems.size()]);
        }
        return null;
    }
}

