/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.AbstractColumnSettingsDataModelProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDataModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.dnd.DND;
import com.extjs.gxt.ui.client.dnd.GridDragSource;
import com.extjs.gxt.ui.client.dnd.GridDropTarget;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.Record;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentPlugin;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.WidgetComponent;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.CheckColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

class ColumnSettingsChooser {
    private final Grid<ColumnDataModel> grid;
    private final AbstractColumnSettingsDataModelProvider columnDataModelProvider;
    private final int maxVisibleColumns;
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public ColumnSettingsChooser(AbstractColumnSettingsDataModelProvider columnDataModelProvider, IViewContext<ICommonClientServiceAsync> viewContext) {
        this.viewContext = viewContext;
        this.columnDataModelProvider = columnDataModelProvider;
        this.maxVisibleColumns = viewContext.getModel().getApplicationInfo().getWebClientConfiguration().getMaxVisibleColumns();
        ArrayList<Object> configs = new ArrayList<Object>();
        CheckColumnConfig isVisibleColumn = this.createIsVisibleColumnConfig();
        CheckColumnConfig hasFilterColumn = new CheckColumnConfig("HAS_FILTER", viewContext.getMessage("GRID_COLUMN_HAS_FILTER_HEADER", new Object[0]), 75);
        ColumnConfig nameColumn = new ColumnConfig("header", viewContext.getMessage("GRID_COLUMN_NAME_HEADER", new Object[0]), 300);
        configs.add(isVisibleColumn);
        configs.add(hasFilterColumn);
        configs.add(nameColumn);
        for (ColumnConfig columnConfig : configs) {
            columnConfig.setSortable(false);
            columnConfig.setMenuDisabled(true);
        }
        this.grid = new Grid(this.createStore(), new ColumnModel(configs));
        this.grid.setHideHeaders(false);
        this.grid.addPlugin((ComponentPlugin)isVisibleColumn);
        this.grid.addPlugin((ComponentPlugin)hasFilterColumn);
        new GridDragSource(this.grid);
        GridDropTarget gridDropTarget = new GridDropTarget(this.grid);
        gridDropTarget.setAllowSelfAsSource(true);
        gridDropTarget.setFeedback(DND.Feedback.INSERT);
    }

    private String createVisibleColumnsLimitExceededMsg(int limit) {
        return this.viewContext.getMessage("VISIBLE_COLUMNS_LIMIT_EXCEEDED_MSG", limit);
    }

    private String createVisibleColumnsLimitReachedMsg(int limit) {
        return this.viewContext.getMessage("VISIBLE_COLUMNS_LIMIT_REACHED_MSG", limit);
    }

    private CheckColumnConfig createIsVisibleColumnConfig() {
        return new CheckColumnConfig("IS_VISIBLE", this.viewContext.getMessage("GRID_IS_COLUMN_VISIBLE_HEADER", new Object[0]), 55){

            protected void onMouseDown(GridEvent<ModelData> ge) {
                String cls = ge.getTarget().getClassName();
                if (cls != null && cls.indexOf("x-grid3-cc-" + this.getId()) != -1 && cls.indexOf("disabled") == -1) {
                    ge.stopEvent();
                    int index = this.grid.getView().findRowIndex((Element)ge.getTarget());
                    ModelData m = this.grid.getStore().getAt(index);
                    Record r = this.grid.getStore().getRecord(m);
                    boolean b = (Boolean)m.get(this.getDataIndex());
                    int counter = this.countVisible();
                    if (!b) {
                        if (counter == ColumnSettingsChooser.this.maxVisibleColumns - 1) {
                            GWTUtils.displayInfo(ColumnSettingsChooser.this.createVisibleColumnsLimitReachedMsg(ColumnSettingsChooser.this.maxVisibleColumns), "", GWTUtils.DisplayInfoTime.SHORT);
                        }
                        if (counter >= ColumnSettingsChooser.this.maxVisibleColumns) {
                            MessageBox.alert((String)"Warning", (String)ColumnSettingsChooser.this.createVisibleColumnsLimitExceededMsg(ColumnSettingsChooser.this.maxVisibleColumns), null);
                        } else {
                            r.set(this.getDataIndex(), (Object)(!b ? 1 : 0));
                        }
                    } else {
                        if (counter == ColumnSettingsChooser.this.maxVisibleColumns + 1) {
                            GWTUtils.displayInfo(ColumnSettingsChooser.this.createVisibleColumnsLimitReachedMsg(ColumnSettingsChooser.this.maxVisibleColumns), GWTUtils.DisplayInfoTime.SHORT);
                        }
                        r.set(this.getDataIndex(), (Object)(!b ? 1 : 0));
                    }
                }
            }

            private int countVisible() {
                int counter = 0;
                for (ModelData m : this.grid.getStore().getModels()) {
                    Record r = this.grid.getStore().getRecord(m);
                    Object visible = r.get(Selectable.VISIBLE.columnName);
                    if (!Boolean.parseBoolean(visible.toString())) continue;
                    ++counter;
                }
                return counter;
            }
        };
    }

    private void enableButtonOnGridSelectedItem(final Button button, final String enabledTitle) {
        button.disable();
        GWTUtils.setToolTip((Component)button, "Select a single table row first or drag selected rows.");
        this.grid.getSelectionModel().addListener(Events.SelectionChange, (Listener)new Listener<SelectionChangedEvent<ModelData>>(){

            public void handleEvent(SelectionChangedEvent<ModelData> se) {
                if (ColumnSettingsChooser.this.grid.getSelectionModel().getSelectedItems().size() == 1) {
                    button.enable();
                    GWTUtils.setToolTip((Component)button, enabledTitle);
                } else {
                    button.disable();
                    GWTUtils.setToolTip((Component)button, "Select a single table row first or drag selected rows.");
                }
            }
        });
    }

    private ListStore<ColumnDataModel> createStore() {
        List<ColumnDataModel> columnDataModels = this.columnDataModelProvider.getColumnDataModels();
        List<ColumnDataModel> newOrderedItems = this.grid == null || this.grid.getStore() == null ? columnDataModels : ColumnSettingsChooser.keepPreviousOrder(columnDataModels, this.grid.getStore().getModels());
        ListStore store = new ListStore();
        store.add(newOrderedItems);
        return store;
    }

    private static List<ColumnDataModel> keepPreviousOrder(List<ColumnDataModel> newColumnDataModels, List<ColumnDataModel> prevOrderedItems) {
        ArrayList<ColumnDataModel> temporaryModels = new ArrayList<ColumnDataModel>(newColumnDataModels);
        ArrayList<ColumnDataModel> newOrderedItems = new ArrayList<ColumnDataModel>();
        for (ColumnDataModel prevModel : prevOrderedItems) {
            int ix = ColumnSettingsChooser.findIx(temporaryModels, prevModel.getColumnID());
            if (ix == -1) continue;
            newOrderedItems.add((ColumnDataModel)((Object)temporaryModels.get(ix)));
            temporaryModels.remove(ix);
        }
        for (ColumnDataModel newItems : temporaryModels) {
            newOrderedItems.add(newItems);
        }
        return newOrderedItems;
    }

    private static int findIx(List<ColumnDataModel> columnDataModels, String columnID) {
        int i = 0;
        while (i < columnDataModels.size()) {
            if (columnDataModels.get(i).getColumnID().equals(columnID)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Component getComponent() {
        ContentPanel cp = new ContentPanel();
        cp.setHeaderVisible(false);
        cp.setBottomComponent((Component)new BottomToolbar());
        this.grid.setAutoWidth(true);
        this.grid.setAutoHeight(true);
        cp.add(this.grid);
        cp.setScrollMode(Style.Scroll.AUTOY);
        return cp;
    }

    private SelectionListener<ButtonEvent> moveSelectedItem(final int delta) {
        return new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                ColumnDataModel m = (ColumnDataModel)ColumnSettingsChooser.this.grid.getSelectionModel().getSelectedItem();
                if (m == null) {
                    return;
                }
                int oldIndex = ColumnSettingsChooser.this.grid.getStore().indexOf((ModelData)m);
                int newIndex = oldIndex + delta;
                if (newIndex >= 0 && newIndex < ColumnSettingsChooser.this.grid.getStore().getCount()) {
                    ColumnSettingsChooser.this.grid.getStore().remove((ModelData)m);
                    ColumnSettingsChooser.this.grid.getStore().insert((ModelData)m, newIndex);
                    ColumnSettingsChooser.this.grid.getSelectionModel().select((ModelData)m, false);
                }
            }
        };
    }

    public void refresh() {
        this.grid.reconfigure(this.createStore(), this.grid.getColumnModel());
    }

    public List<ColumnDataModel> getModels() {
        return this.grid.getStore().getModels();
    }

    class BottomToolbar
    extends ToolBar {
        public BottomToolbar() {
            this.add((Component)new LabelToolItem("Select:"));
            this.add((Component)new WidgetComponent(this.createLink(Selectable.VISIBLE, true, ColumnSettingsChooser.this.maxVisibleColumns, ColumnSettingsChooser.this.createVisibleColumnsLimitExceededMsg(ColumnSettingsChooser.this.maxVisibleColumns))));
            this.add((Component)new SeparatorToolItem());
            this.add((Component)new WidgetComponent(this.createLink(Selectable.VISIBLE, false)));
            this.add((Component)new SeparatorToolItem());
            this.add((Component)new WidgetComponent(this.createLink(Selectable.FILTER, true)));
            this.add((Component)new SeparatorToolItem());
            this.add((Component)new WidgetComponent(this.createLink(Selectable.FILTER, false)));
            this.add((Component)new FillToolItem());
            Button up = new Button("Move Up");
            up.addSelectionListener(ColumnSettingsChooser.this.moveSelectedItem(-1));
            ColumnSettingsChooser.this.enableButtonOnGridSelectedItem(up, "Move selected column to the left in modified table.");
            this.add((Component)up);
            Button down = new Button("Move Down");
            down.addSelectionListener(ColumnSettingsChooser.this.moveSelectedItem(1));
            ColumnSettingsChooser.this.enableButtonOnGridSelectedItem(down, "Move selected column to the right in modified table.");
            this.add((Component)down);
        }

        private Widget createLink(final Selectable selectable, final boolean select) {
            String prefix = select ? "All" : "No";
            String suffix = String.valueOf(selectable.title) + "s";
            String title = String.valueOf(prefix) + " " + suffix;
            return LinkRenderer.getLinkWidget(title, new ClickHandler(){

                public void onClick(ClickEvent event) {
                    for (ColumnDataModel m : ColumnSettingsChooser.this.grid.getStore().getModels()) {
                        Record r = ColumnSettingsChooser.this.grid.getStore().getRecord((ModelData)m);
                        r.set(selectable.columnName, (Object)select);
                    }
                }
            });
        }

        private Widget createLink(final Selectable selectable, final boolean select, final int limit, final String limitExceededMsg) {
            String prefix = select ? "All" : "No";
            String suffix = String.valueOf(selectable.title) + "s";
            String title = String.valueOf(prefix) + " " + suffix;
            return LinkRenderer.getLinkWidget(title, new ClickHandler(){

                public void onClick(ClickEvent event) {
                    int counter = 0;
                    boolean limitReached = false;
                    for (ColumnDataModel m : ColumnSettingsChooser.this.grid.getStore().getModels()) {
                        Record r = ColumnSettingsChooser.this.grid.getStore().getRecord((ModelData)m);
                        if (counter == limit) {
                            limitReached = true;
                            MessageBox.alert((String)"Warning", (String)limitExceededMsg, null);
                        }
                        r.set(selectable.columnName, (Object)(limitReached ? !select : select));
                        ++counter;
                    }
                }
            });
        }
    }

    private static enum Selectable {
        VISIBLE("IS_VISIBLE", "Column"),
        FILTER("HAS_FILTER", "Filter");

        private final String columnName;
        private final String title;

        private Selectable(String columnName, String title) {
            this.columnName = columnName;
            this.title = title;
        }
    }
}

