/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailViewConfiguration;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.TabPanelEvent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.layout.FillLayout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.Element;
import java.util.ArrayList;
import java.util.List;

public class SectionsPanel
extends LayoutContainer {
    public static final String SECTIONS_TAB_PANEL_ID_SUFFIX = "_section_tabs";
    public static final String SECTION_ID_SUFFIX = "_element";
    private final List<SectionElement> elements = new ArrayList<SectionElement>();
    private final TabPanel tabPanel;
    private String displayId;
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public SectionsPanel(IViewContext<ICommonClientServiceAsync> viewContext, String idPrefix) {
        this.viewContext = viewContext;
        this.setLayout((Layout)new FillLayout());
        this.tabPanel = new TabPanel();
        this.tabPanel.setAutoSelect(false);
        this.tabPanel.setId(String.valueOf(idPrefix) + SECTIONS_TAB_PANEL_ID_SUFFIX);
        super.add((Component)this.tabPanel);
    }

    protected void onRender(Element parent, int index) {
        super.onRender(parent, index);
        this.tryApplyDisplaySettings();
    }

    public void tryApplyDisplaySettings() {
        if (this.getDisplayID() != null) {
            String tabToActivateID = this.viewContext.getDisplaySettingsManager().getActiveTabSettings(this.getDisplayID());
            if (tabToActivateID != null) {
                for (SectionElement sectionElement : this.elements) {
                    String thisTabID = sectionElement.getTabContent().getDisplayID();
                    if (!tabToActivateID.equals(thisTabID)) continue;
                    this.tabPanel.setSelection((TabItem)sectionElement);
                    return;
                }
            }
            if (this.elements.size() > 0) {
                this.tabPanel.setSelection((TabItem)this.elements.get(0));
            }
        }
    }

    public void addSection(TabContent tabContent) {
        DetailViewConfiguration viewSettingsOrNull = this.getDisplayID() != null ? this.viewContext.getDisplaySettingsManager().tryGetDetailViewSettings(this.getDisplayID()) : null;
        String panelDisplayId = tabContent.getDisplayID().toUpperCase();
        if (viewSettingsOrNull != null && viewSettingsOrNull.getDisabledTabs().contains(panelDisplayId)) {
            return;
        }
        SectionElement element = new SectionElement(tabContent, this.viewContext);
        tabContent.disableAutoDisposeComponents();
        this.elements.add(element);
        this.addToTabPanel(element);
        tabContent.setParentDisplayID(this.getDisplayID());
    }

    public void selectSection(TabContent tabContent) {
        for (SectionElement element : this.elements) {
            if (!((Object)((Object)element.getTabContent())).equals((Object)tabContent)) continue;
            this.tabPanel.setSelection((TabItem)element);
            break;
        }
    }

    public void selectFirstSection() {
        this.tabPanel.setSelection((TabItem)this.tabPanel.getItem(0));
    }

    protected void onDetach() {
        for (SectionElement el : this.elements) {
            el.getTabContent().disposeComponents();
        }
        super.onDetach();
    }

    private void addToTabPanel(SectionElement element) {
        this.tabPanel.add((TabItem)element);
    }

    @Deprecated
    protected boolean add(Component item) {
        return super.add(item);
    }

    public String getDisplayID() {
        return this.displayId;
    }

    public void setDisplayID(IDisplayTypeIDGenerator generator, String suffix) {
        this.displayId = suffix != null ? generator.createID(suffix) : generator.createID();
    }

    private class SectionElement
    extends TabItem {
        private TabContent tabContent;

        public SectionElement(final TabContent tabContent, final IViewContext<ICommonClientServiceAsync> viewContext) {
            this.setClosable(false);
            this.setLayout((Layout)new FitLayout());
            this.setTabContent(tabContent);
            this.setText(tabContent.getHeading());
            this.add((Component)tabContent);
            this.setId(String.valueOf(tabContent.getId()) + SectionsPanel.SECTION_ID_SUFFIX);
            this.addListener(Events.Select, (Listener)new Listener<TabPanelEvent>(){

                public void handleEvent(TabPanelEvent be) {
                    tabContent.setContentVisible(true);
                    if (SectionsPanel.this.getDisplayID() != null) {
                        viewContext.getDisplaySettingsManager().storeActiveTabSettings(SectionsPanel.this.getDisplayID(), tabContent.getDisplayID(), (Object)SectionsPanel.this);
                    }
                }
            });
            this.setHideMode(Style.HideMode.OFFSETS);
        }

        void setTabContent(TabContent tabContent) {
            this.tabContent = tabContent;
        }

        TabContent getTabContent() {
            return this.tabContent;
        }
    }
}

