/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractExperimentPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

public class ExperimentUpdatesPredicate
extends AbstractExperimentPredicate<ExperimentUpdatesDTO> {
    @Override
    public final String getCandidateDescription() {
        return "experiment updates";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, ExperimentUpdatesDTO updates) {
        assert (this.spacePredicate.initialized) : "Predicate has not been initialized";
        assert (this.experimentTechIdPredicate.initialized) : "Predicate has not been initialized";
        if (ExperimentUpdatesPredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
            return Status.OK;
        }
        Status status = this.experimentTechIdPredicate.doEvaluation(person, allowedRoles, updates.getExperimentId());
        if (!status.equals(Status.OK)) {
            return status;
        }
        status = this.spacePredicate.doEvaluation(person, allowedRoles, updates.getProjectIdentifier());
        return status;
    }
}

