/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ShouldFlattenCollections;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.SpaceCodeHelper;
import java.util.List;

@ShouldFlattenCollections
public class SpaceIdentifierPredicate
extends AbstractSpacePredicate<SpaceIdentifier> {
    public SpaceIdentifierPredicate() {
    }

    public SpaceIdentifierPredicate(boolean okForNonExistentSpaces) {
        super(okForNonExistentSpaces);
    }

    @Override
    public final String getCandidateDescription() {
        return "space identifier";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, SpaceIdentifier spaceIdentifier) {
        if (SpaceIdentifierPredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
            return Status.OK;
        }
        assert (this.initialized) : "Predicate has not been initialized";
        String spaceCode = SpaceCodeHelper.getSpaceCode(person, spaceIdentifier);
        DatabaseInstancePE databaseInstance = this.getDatabaseInstance(spaceIdentifier);
        return this.evaluate(person, allowedRoles, databaseInstance, spaceCode);
    }
}

