/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.validator;

import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.DatabaseInstanceValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.IValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SpaceValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.Set;

public final class SampleValidator
extends AbstractValidator<Sample> {
    private final IValidator<Space> spaceValidator = new SpaceValidator();
    private final IValidator<DatabaseInstance> databaseInstanceValidator = new DatabaseInstanceValidator();

    @Override
    public final boolean doValidation(PersonPE person, Sample value) {
        Space space = value.getSpace();
        if (space != null) {
            return this.matchesSpace(person, space);
        }
        DatabaseInstance databaseInstance = value.getDatabaseInstance();
        return this.matchesDatabaseInstanceOfRoleAssignment(person, databaseInstance) || this.matchesDatabaseInstanceOfRoleAssignmentSpace(person, databaseInstance);
    }

    private boolean matchesSpace(PersonPE person, Space space) {
        return this.spaceValidator.isValid(person, space);
    }

    private boolean matchesDatabaseInstanceOfRoleAssignment(PersonPE person, DatabaseInstance databaseInstance) {
        return this.databaseInstanceValidator.isValid(person, databaseInstance);
    }

    private boolean matchesDatabaseInstanceOfRoleAssignmentSpace(PersonPE person, DatabaseInstance databaseInstance) {
        Set<RoleAssignmentPE> roleAssignments = person.getAllPersonRoles();
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            SpacePE space = roleAssignment.getSpace();
            if (space == null || databaseInstance == null || !space.getDatabaseInstance().getUuid().equals(databaseInstance.getUuid())) continue;
            return true;
        }
        return false;
    }
}

