/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.validator;

import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExperimentValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExternalDataValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SampleValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchDomainSearchResultWithFullEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;

public class SearchDomainSearchResultValidator
extends AbstractValidator<SearchDomainSearchResultWithFullEntity> {
    private final ExternalDataValidator dataSetValidator = new ExternalDataValidator();
    private final SampleValidator sampleValidator = new SampleValidator();
    private final ExperimentValidator experimentValidator = new ExperimentValidator();

    @Override
    public boolean doValidation(PersonPE person, SearchDomainSearchResultWithFullEntity value) {
        IEntityInformationHolderWithPermId entity = value.getEntity();
        if (entity instanceof Sample) {
            return this.sampleValidator.isValid(person, (Sample)entity);
        }
        if (entity instanceof Experiment) {
            return this.experimentValidator.isValid(person, (Experiment)entity);
        }
        if (entity instanceof AbstractExternalData) {
            return this.dataSetValidator.isValid(person, (AbstractExternalData)entity);
        }
        return false;
    }
}

