/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.IServiceConversationClientManagerLocal;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractSampleIdentifierBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.RelationshipUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.FileFormatTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractDataSetBusinessObject
extends AbstractSampleIdentifierBusinessObject {
    protected IRelationshipService relationshipService;
    private IServiceConversationClientManagerLocal conversationClient;

    public AbstractDataSetBusinessObject(IDAOFactory daoFactory, Session session, IRelationshipService relationshipService, IServiceConversationClientManagerLocal conversationClient, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, EntityKind.DATA_SET, managedPropertyEvaluatorFactory);
        this.relationshipService = relationshipService;
        this.conversationClient = conversationClient;
    }

    public AbstractDataSetBusinessObject(IDAOFactory daoFactory, Session session, IEntityPropertiesConverter entityPropertiesConverter, IRelationshipService relationshipService, IServiceConversationClientManagerLocal conversationClient, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, entityPropertiesConverter, managedPropertyEvaluatorFactory);
        this.relationshipService = relationshipService;
        this.conversationClient = conversationClient;
    }

    protected void enrichWithParentsAndExperiment(DataPE dataPE) {
        HibernateUtils.initialize(dataPE.getParents());
        HibernateUtils.initialize(dataPE.getExperiment());
    }

    protected void enrichWithChildren(DataPE dataPE) {
        HibernateUtils.initialize(dataPE.getChildRelationships());
    }

    protected void checkPropertiesBusinessRules(DataPE data) {
        this.entityPropertiesConverter.checkMandatoryProperties(data.getProperties(), data.getDataSetType());
    }

    protected void updateSample(DataPE data, SampleIdentifier sampleIdentifierOrNull) {
        SamplePE previousSampleOrNull;
        assert (sampleIdentifierOrNull != null);
        SamplePE newSample = this.getSampleByIdentifier(sampleIdentifierOrNull);
        if (newSample.equals(previousSampleOrNull = data.tryGetSample())) {
            return;
        }
        if (newSample.getSpace() == null) {
            throw this.createWrongSampleException(data, newSample, "the new sample is shared");
        }
        ExperimentPE experiment = newSample.getExperiment();
        if (experiment == null) {
            throw this.createWrongSampleException(data, newSample, "the new sample is not connected to any experiment");
        }
        this.relationshipService.assignDataSetToSample(this.session, data, newSample);
    }

    protected void updateExperiment(DataPE data, ExperimentIdentifier experimentIdentifier) {
        assert (experimentIdentifier != null);
        ExperimentPE experiment = this.getExperimentByIdentifier(experimentIdentifier);
        this.updateExperiment(data, experiment);
    }

    protected void updateExperiment(DataPE data, ExperimentPE experiment) {
        if (!experiment.equals(data.getExperiment())) {
            this.relationshipService.assignDataSetToExperiment(this.session, data, experiment);
        }
    }

    protected ExperimentPE getExperimentByIdentifier(ExperimentIdentifier identifier) {
        assert (identifier != null) : "Experiment identifier unspecified.";
        ProjectPE project = this.getProjectDAO().tryFindProject(identifier.getDatabaseInstanceCode(), identifier.getSpaceCode(), identifier.getProjectCode());
        if (project == null) {
            throw new UserFailureException("Unkown experiment because of unkown project: " + identifier);
        }
        ExperimentPE exp = this.getExperimentDAO().tryFindByCodeAndProject(project, identifier.getExperimentCode());
        return exp;
    }

    protected void setContainedDataSets(DataPE container, List<String> modifiedContainedCodesOrNull) {
        if (modifiedContainedCodesOrNull == null) {
            return;
        }
        Set<DataPE> containedPEs = this.findDataSetsByCodes(AbstractDataSetBusinessObject.asSet(modifiedContainedCodesOrNull));
        this.replaceContainedDataSets(container, containedPEs);
    }

    protected void replaceContainedDataSets(DataPE container, Set<DataPE> newContainedDataSets) {
        ArrayList<DataPE> contained = new ArrayList<DataPE>();
        contained.addAll(container.getContainedDataSets());
        for (DataPE dataPE : contained) {
            this.relationshipService.removeDataSetFromContainer(this.session, dataPE);
        }
        for (DataPE dataPE : newContainedDataSets) {
            this.relationshipService.assignDataSetToContainer(this.session, dataPE, container);
            this.validateContainerContainedRelationshipGraph(container, dataPE);
        }
    }

    protected void setParents(DataPE childPE, List<String> modifiedParentDatasetCodesOrNull) {
        if (modifiedParentDatasetCodesOrNull == null) {
            return;
        }
        for (String parentCode : modifiedParentDatasetCodesOrNull) {
            if (!parentCode.equals(childPE.getCode())) continue;
            throw new UserFailureException("Data set '" + childPE.getCode() + "' can not be its own parent.");
        }
        Set<DataPE> parentPEs = this.findDataSetsByCodes(AbstractDataSetBusinessObject.asSet(modifiedParentDatasetCodesOrNull));
        this.replaceParents(childPE, parentPEs, true);
    }

    protected void replaceParents(DataPE child, Set<DataPE> newParents, boolean validate) {
        for (DataPE parent : newParents) {
            this.checkParentDeletion(parent, child.getCode());
        }
        ArrayList<DataPE> oldParents = new ArrayList<DataPE>();
        for (DataSetRelationshipPE oldParentRelation : child.getParentRelationships()) {
            oldParents.add(oldParentRelation.getParentDataSet());
        }
        HashSet<DataPE> parentsToRemove = new HashSet<DataPE>();
        HashSet<DataPE> parentsToAdd = new HashSet<DataPE>();
        for (DataPE newParent : newParents) {
            if (oldParents.contains(newParent)) continue;
            parentsToAdd.add(newParent);
        }
        for (DataPE oldParent : oldParents) {
            if (newParents.contains(oldParent)) continue;
            parentsToRemove.add(oldParent);
        }
        if (validate) {
            this.validateParentsRelationshipGraph(child, parentsToAdd);
        }
        for (DataPE parentToRemove : parentsToRemove) {
            this.relationshipService.removeParentFromDataSet(this.session, child, parentToRemove);
        }
        for (DataPE parentToAdd : parentsToAdd) {
            this.relationshipService.addParentToDataSet(this.session, child, parentToAdd);
        }
    }

    private void checkParentDeletion(DataPE parentPE, String child) {
        if (parentPE.getDeletion() != null) {
            throw UserFailureException.fromTemplate("Data set '%s' has been deleted and can't become a parent of data set '%s'.", parentPE.getIdentifier(), child);
        }
    }

    protected void validateParentsRelationshipGraph(DataPE data, Collection<DataPE> parentsToAdd) {
        for (DataPE parentToAdd : parentsToAdd) {
            this.validateParentsRelationshipGraph(data, parentToAdd);
        }
    }

    private void validateParentsRelationshipGraph(DataPE data, DataPE parentToAdd) {
        TechId updatedDataSetId = TechId.create(data);
        HashSet<TechId> visited = new HashSet<TechId>();
        Set<TechId> toVisit = new HashSet<TechId>();
        toVisit.add(TechId.create(parentToAdd));
        while (!toVisit.isEmpty()) {
            if (toVisit.contains(updatedDataSetId)) {
                throw UserFailureException.fromTemplate("Data Set '%s' is an ancestor of Data Set '%s' and cannot be at the same time set as its child.", data.getCode(), parentToAdd.getCode());
            }
            Set<TechId> nextToVisit = this.findParentIds(toVisit);
            visited.addAll(toVisit);
            nextToVisit.removeAll(visited);
            toVisit = nextToVisit;
        }
    }

    private Set<TechId> findParentIds(Set<TechId> dataSetIds) {
        return this.getDataDAO().findParentIds(dataSetIds);
    }

    protected Set<DataPE> findDataSetsByCodes(Collection<String> codes) {
        IDataDAO dao = this.getDataDAO();
        HashSet<DataPE> dataSets = new HashSet<DataPE>();
        ArrayList<String> missingDataSetCodes = new ArrayList<String>();
        for (String code : codes) {
            DataPE dataSetOrNull = dao.tryToFindDataSetByCode(code);
            if (dataSetOrNull == null) {
                missingDataSetCodes.add(code);
                continue;
            }
            dataSets.add(dataSetOrNull);
        }
        if (missingDataSetCodes.size() > 0) {
            throw UserFailureException.fromTemplate("Data Sets with following codes do not exist: '%s'.", CollectionUtils.abbreviate(missingDataSetCodes, 10));
        }
        return dataSets;
    }

    protected void updateContainer(DataPE data, String containerCode) {
        if (containerCode == null) {
            if (data.getContainer() != null) {
                this.relationshipService.removeDataSetFromContainer(this.session, data);
            }
        } else {
            DataPE container = this.getDataDAO().tryToFindDataSetByCode(containerCode);
            if (container == null) {
                throw UserFailureException.fromTemplate("Data Set with a following code doesn't exist: '%s'.", containerCode);
            }
            if (!container.isContainer()) {
                throw UserFailureException.fromTemplate("Data Set with a following code is not a container: '%s'.", containerCode);
            }
            this.validateContainerContainedRelationshipGraph(container, data);
            this.relationshipService.assignDataSetToContainer(this.session, data, container);
        }
    }

    private void validateContainerContainedRelationshipGraph(DataPE container, DataPE contained) {
        if (container.getCode().equals(contained.getCode())) {
            throw new UserFailureException("Data set '" + container.getCode() + "' cannot contain itself as a component neither directly nor via subordinate components.");
        }
        if (container.getContainer() != null) {
            this.validateContainerContainedRelationshipGraph(container.getContainer(), contained);
        }
    }

    protected void updateFileFormatType(DataPE data, String fileFormatTypeCode) {
        if (data.isExternalData()) {
            if (fileFormatTypeCode == null) {
                throw new UserFailureException("Data set '" + data.getCode() + "' cannot have empty file format.");
            }
            ExternalDataPE externalData = data.tryAsExternalData();
            FileFormatTypePE fileFormatTypeOrNull = this.getFileFormatTypeDAO().tryToFindFileFormatTypeByCode(fileFormatTypeCode);
            if (fileFormatTypeOrNull == null) {
                throw new UserFailureException(String.format("File type '%s' does not exist.", fileFormatTypeCode));
            }
            if (!this.equalFileFormatTypes(externalData.getFileFormatType(), fileFormatTypeOrNull)) {
                externalData.setFileFormatType(fileFormatTypeOrNull);
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)data, this.session);
            }
        }
    }

    private boolean equalFileFormatTypes(FileFormatTypePE type1, FileFormatTypePE type2) {
        return type1 == null ? type1 == type2 : type1.equals(type2);
    }

    protected void checkSameSpace(DataPE container, DataPE component) {
        if (container.getSpace().equals(component.getSpace())) {
            return;
        }
        throw UserFailureException.fromTemplate("Data set '%s' must be in the same space ('%s') as its container.", component.getCode(), container.getSpace().getCode());
    }

    protected void checkSameSpace(DataPE container, List<DataPE> components) {
        for (DataPE component : components) {
            this.checkSameSpace(container, component);
        }
    }

    protected static Set<String> extractCodes(Collection<DataPE> parents) {
        HashSet<String> codes = new HashSet<String>(parents.size());
        for (DataPE parent : parents) {
            codes.add(parent.getCode());
        }
        return codes;
    }

    protected static Set<String> asSet(List<String> objects) {
        return new LinkedHashSet<String>(objects);
    }

    private UserFailureException createWrongSampleException(DataPE data, SamplePE sample, String reason) {
        return UserFailureException.fromTemplate("The dataset '%s' cannot be connected to the sample '%s' because %s.", data.getCode(), sample.getIdentifier(), reason);
    }

    public IRelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    public IServiceConversationClientManagerLocal getConversationClient() {
        return this.conversationClient;
    }
}

