/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractMaterialBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IMaterialTable;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterialWithType;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialUpdateDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;

public final class MaterialTable
extends AbstractMaterialBusinessObject
implements IMaterialTable {
    private List<MaterialPE> materials;
    private boolean dataChanged;

    public MaterialTable(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, managedPropertyEvaluatorFactory);
    }

    @Private
    MaterialTable(IDAOFactory daoFactory, Session session, IEntityPropertiesConverter entityPropertiesConverter, List<MaterialPE> materials, boolean dataChanged, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, entityPropertiesConverter, managedPropertyEvaluatorFactory);
        this.materials = materials;
        this.dataChanged = dataChanged;
    }

    @Override
    public final List<MaterialPE> getMaterials() {
        assert (this.materials != null) : "Materials have not been loaded.";
        return this.materials;
    }

    @Override
    public void add(List<NewMaterial> newMaterials, MaterialTypePE materialTypePE) {
        assert (newMaterials != null) : "New materials undefined.";
        assert (materialTypePE != null) : "Material type undefined.";
        if (this.materials == null) {
            this.materials = new ArrayList<MaterialPE>();
        }
        this.setBatchUpdateMode(true);
        for (NewMaterial newMaterial : newMaterials) {
            this.materials.add(this.createMaterial(newMaterial, materialTypePE));
        }
        this.setBatchUpdateMode(false);
        this.dataChanged = true;
    }

    @Override
    public void add(List<NewMaterialWithType> newMaterials, Map<String, MaterialTypePE> materialTypePE) {
        assert (newMaterials != null) : "New materials undefined.";
        assert (materialTypePE != null) : "Material type undefined.";
        if (this.materials == null) {
            this.materials = new ArrayList<MaterialPE>();
        }
        this.setBatchUpdateMode(true);
        for (NewMaterialWithType newMaterial : newMaterials) {
            this.materials.add(this.createMaterial(newMaterial.getMaterial(), materialTypePE.get(newMaterial.getType())));
        }
        this.setBatchUpdateMode(false);
        this.dataChanged = true;
    }

    @Override
    public void save() {
        assert (this.materials != null) : "Materials have not been loaded.";
        assert (this.dataChanged) : "Data not changed";
        try {
            this.getMaterialDAO().createOrUpdateMaterials(this.materials);
            this.checkBusinessRules();
        }
        catch (DataAccessException ex) {
            MaterialTable.throwException(ex, String.format("One of materials", new Object[0]));
        }
        this.dataChanged = false;
    }

    private void checkBusinessRules() {
        HashMap<EntityTypePE, List<EntityTypePropertyTypePE>> cache = new HashMap<EntityTypePE, List<EntityTypePropertyTypePE>>();
        for (MaterialPE m : this.materials) {
            this.entityPropertiesConverter.checkMandatoryProperties(m.getProperties(), m.getMaterialType(), cache);
        }
    }

    private MaterialPE createMaterial(NewMaterial newMaterial, MaterialTypePE materialTypePE) {
        MaterialPE material = new MaterialPE();
        material.setCode(newMaterial.getCode());
        material.setRegistrator(this.findPerson());
        material.setMaterialType(materialTypePE);
        material.setDatabaseInstance(this.getHomeDatabaseInstance());
        if (newMaterial.getProperties().length > 0) {
            this.defineMaterialProperties(material, newMaterial.getProperties());
        }
        return material;
    }

    private final void defineMaterialProperties(MaterialPE material, IEntityProperty[] materialProperties) {
        String materialTypeCode = material.getMaterialType().getCode();
        List properties = this.entityPropertiesConverter.convertProperties(materialProperties, materialTypeCode, material.getRegistrator());
        for (MaterialPropertyPE materialProperty : properties) {
            material.addProperty(materialProperty);
        }
    }

    @Override
    public void update(List<MaterialUpdateDTO> materialsUpdate) {
        this.setBatchUpdateMode(true);
        ArrayList<Long> materialIds = new ArrayList<Long>();
        for (MaterialUpdateDTO materialUpdate : materialsUpdate) {
            materialIds.add(materialUpdate.getMaterialId().getId());
        }
        this.materials = this.getMaterialDAO().listMaterialsById(materialIds);
        HashMap<Long, MaterialPE> materialsById = new HashMap<Long, MaterialPE>();
        for (MaterialPE material : this.materials) {
            materialsById.put(material.getId(), material);
        }
        for (MaterialUpdateDTO materialUpdate : materialsUpdate) {
            MaterialPE material = (MaterialPE)materialsById.get(materialUpdate.getMaterialId().getId());
            this.update(material, materialUpdate);
        }
        this.setBatchUpdateMode(false);
        this.dataChanged = true;
    }

    private void update(MaterialPE material, MaterialUpdateDTO materialUpdate) {
        if (!materialUpdate.getVersion().equals(material.getModificationDate())) {
            MaterialTable.throwModifiedEntityException("Material");
        }
        Set<MaterialPropertyPE> newProperties = this.calculateNewProperties(material, materialUpdate.getProperties());
        material.setProperties(newProperties);
    }

    private Set<MaterialPropertyPE> calculateNewProperties(MaterialPE material, List<IEntityProperty> propertiesToUpdate) {
        Set<MaterialPropertyPE> existingProperties = material.getProperties();
        MaterialTypePE type = material.getMaterialType();
        PersonPE registrator = this.findPerson();
        Set<String> propertiesToUpdateNames = MaterialTable.extractCodes(propertiesToUpdate);
        return this.entityPropertiesConverter.updateProperties(existingProperties, type, propertiesToUpdate, registrator, propertiesToUpdateNames);
    }

    private static Set<String> extractCodes(List<IEntityProperty> propertiesToUpdate) {
        HashSet<String> names = new HashSet<String>();
        for (IEntityProperty p : propertiesToUpdate) {
            names.add(p.getPropertyType().getCode());
        }
        return names;
    }

    @Override
    public void deleteByTechIds(List<TechId> materialIds, String reason) throws UserFailureException {
        try {
            this.getSessionFactory().getCurrentSession().flush();
            this.getSessionFactory().getCurrentSession().clear();
            this.getMaterialDAO().delete(materialIds, this.session.tryGetPerson(), reason);
        }
        catch (DataAccessException ex) {
            String errorSubject = "Material";
            if (ex.getCause() != null && ex instanceof DataIntegrityViolationException) {
                String materialPermId = ex.getCause().getMessage();
                errorSubject = String.valueOf(errorSubject) + " '" + materialPermId + "'";
            }
            MaterialTable.throwException(ex, errorSubject, EntityKind.MATERIAL);
        }
    }
}

