/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.datasetlister;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.datasetlister.DataSetDownloadRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.datasetlister.DataSetRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.datasetlister.DataSetRelationRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.datasetlister.IDataSetLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.datasetlister.IDataSetListingQuery;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOptions;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataStoreURLForDataSets;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkDataSetUrl;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.lemnik.eodsql.QueryTool;
import org.apache.commons.lang.StringUtils;

public class DataSetLister
implements IDataSetLister {
    private IDataSetListingQuery query;

    public DataSetLister(IAuthorizationDAOFactory daoFactory, PersonPE person) {
        this((IDataSetListingQuery)QueryTool.getManagedQuery(IDataSetListingQuery.class), person);
    }

    public DataSetLister(IDataSetListingQuery query, PersonPE person) {
        if (query == null) {
            throw new IllegalArgumentException("Query was null");
        }
        if (person == null) {
            throw new IllegalArgumentException("Person was null");
        }
        this.query = query;
    }

    @Override
    public List<DataSet> getDataSetMetaData(List<String> dataSetCodes, DataSetFetchOptions dataSetFetchOptions) {
        if (dataSetCodes == null) {
            throw new IllegalArgumentException("DataSetCodes were null");
        }
        if (dataSetFetchOptions == null) {
            throw new IllegalArgumentException("DataSetFetchOptions were null");
        }
        if (!dataSetFetchOptions.isSubsetOf(new DataSetFetchOption[]{DataSetFetchOption.BASIC, DataSetFetchOption.PARENTS, DataSetFetchOption.CHILDREN, DataSetFetchOption.METAPROJECTS})) {
            throw new IllegalArgumentException("Currently only " + DataSetFetchOption.BASIC + "," + DataSetFetchOption.PARENTS + ", and " + DataSetFetchOption.CHILDREN + " and " + DataSetFetchOption.METAPROJECTS + " fetch options are supported by this method");
        }
        String[] dataSetCodesArray = dataSetCodes.toArray(new String[dataSetCodes.size()]);
        List<DataSetRecord> dataSetRecords = this.query.getDataSetMetaData(dataSetCodesArray);
        List<DataSet.DataSetInitializer> dataSetInitializers = this.createDataSetInitializers(dataSetRecords, dataSetCodesArray);
        if (dataSetFetchOptions.isSupersetOf(new DataSetFetchOption[]{DataSetFetchOption.PARENTS})) {
            this.enrichDataSetInitializersWithParents(dataSetInitializers, dataSetCodesArray);
        }
        if (dataSetFetchOptions.isSupersetOf(new DataSetFetchOption[]{DataSetFetchOption.CHILDREN})) {
            this.enrichDataSetInitializersWithChildren(dataSetInitializers, dataSetCodesArray);
        }
        return this.createDataSets(dataSetInitializers, dataSetFetchOptions);
    }

    private List<DataSet> createDataSets(List<DataSet.DataSetInitializer> dataSetInitializers, DataSetFetchOptions dataSetFetchOptions) {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>(dataSetInitializers.size());
        for (DataSet.DataSetInitializer dataSetInitializer : dataSetInitializers) {
            DataSet dataSet = new DataSet(dataSetInitializer);
            dataSet.setFetchOptions(dataSetFetchOptions);
            dataSets.add(dataSet);
        }
        return dataSets;
    }

    private List<DataSet.DataSetInitializer> createDataSetInitializers(List<DataSetRecord> dataSetRecords, String[] dataSetCodes) {
        if (dataSetRecords != null) {
            HashMap<String, DataSet.DataSetInitializer> dataSetMap = new HashMap<String, DataSet.DataSetInitializer>();
            for (DataSetRecord dataSetRecord : dataSetRecords) {
                DataSet.DataSetInitializer dataSet = this.createDataSetInitializer(dataSetRecord);
                dataSetMap.put(dataSet.getCode(), dataSet);
            }
            ArrayList<DataSet.DataSetInitializer> dataSetList = new ArrayList<DataSet.DataSetInitializer>(dataSetMap.size());
            String[] stringArray = dataSetCodes;
            int n = dataSetCodes.length;
            int n2 = 0;
            while (n2 < n) {
                String dataSetCode = stringArray[n2];
                DataSet.DataSetInitializer dataSet = (DataSet.DataSetInitializer)dataSetMap.get(dataSetCode);
                if (dataSet == null) {
                    throw new UserFailureException("Unknown data set " + dataSetCode);
                }
                dataSetList.add(dataSet);
                ++n2;
            }
            return dataSetList;
        }
        return Collections.emptyList();
    }

    private DataSet.DataSetInitializer createDataSetInitializer(DataSetRecord dataSet) {
        DatabaseInstanceIdentifier experimentDatabaseIdentifier = new DatabaseInstanceIdentifier(dataSet.die_is_original_source, dataSet.die_code);
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifier(experimentDatabaseIdentifier.getDatabaseInstanceCode(), dataSet.spe_code, dataSet.pre_code, dataSet.ex_code);
        DataSet.DataSetInitializer initializer = new DataSet.DataSetInitializer();
        initializer.setId(dataSet.ds_id);
        initializer.setCode(dataSet.ds_code);
        initializer.setDataSetTypeCode(dataSet.dt_code);
        initializer.setContainerDataSet(DataSetKind.CONTAINER.name().equals(dataSet.dt_data_set_kind));
        initializer.setStorageConfirmed(dataSet.ed_sc == null || dataSet.ed_sc != false);
        initializer.setStub(false);
        if (!initializer.isContainerDataSet()) {
            initializer.setPostRegistered(dataSet.ds_is_post_registered);
        }
        initializer.setLinkDataSet(DataSetKind.LINK.name().equals(dataSet.dt_data_set_kind));
        if (initializer.isLinkDataSet()) {
            initializer.setExternalDataSetCode(dataSet.ld_external_code);
            LinkDataSetUrl linkDataSetUrl = new LinkDataSetUrl(dataSet.ld_external_code, dataSet.edms_url_template);
            initializer.setExternalDataSetLink(linkDataSetUrl.toString());
            DatabaseInstance db = new DatabaseInstance();
            db.setId(dataSet.die_id);
            db.setCode(dataSet.die_code);
            db.setUuid(dataSet.die_uuid);
            db.setHomeDatabase(dataSet.die_is_original_source);
            ExternalDataManagementSystem edms = new ExternalDataManagementSystem();
            edms.setId(dataSet.edms_id);
            edms.setCode(dataSet.edms_code);
            edms.setLabel(dataSet.edms_label);
            edms.setUrlTemplate(dataSet.edms_url_template);
            edms.setDatabaseInstance(db);
            edms.setOpenBIS(dataSet.edms_is_openbis);
            initializer.setExternalDataManagementSystem(edms);
        }
        if (dataSet.ctnr_id != null) {
            DataSet.DataSetInitializer containerInitializer = new DataSet.DataSetInitializer();
            containerInitializer.setStub(true);
            containerInitializer.setId(dataSet.ctnr_id);
            containerInitializer.setCode(dataSet.ctnr_code);
            initializer.setContainerOrNull(new DataSet(containerInitializer));
        }
        initializer.setRegistrationDetails(this.createDataSetRegistrationDetails(dataSet));
        initializer.setExperimentIdentifier(experimentIdentifier.toString());
        if (dataSet.sa_code != null) {
            DatabaseInstanceIdentifier sampleDatabaseIdentifier = null;
            if (dataSet.sa_dbin_id != null) {
                sampleDatabaseIdentifier = experimentDatabaseIdentifier;
            }
            SpaceIdentifier sampleSpaceIdentifier = null;
            if (dataSet.sps_code != null) {
                sampleSpaceIdentifier = new SpaceIdentifier(experimentDatabaseIdentifier.getDatabaseInstanceCode(), dataSet.sps_code);
            }
            SampleIdentifier sampleIdentifier = IdentifierHelper.createSampleIdentifier(sampleDatabaseIdentifier, sampleSpaceIdentifier, dataSet.sa_code, dataSet.sac_code);
            initializer.setSampleIdentifierOrNull(sampleIdentifier.toString());
        }
        return initializer;
    }

    private EntityRegistrationDetails createDataSetRegistrationDetails(DataSetRecord dataSet) {
        EntityRegistrationDetails.EntityRegistrationDetailsInitializer initializer = new EntityRegistrationDetails.EntityRegistrationDetailsInitializer();
        initializer.setUserId(dataSet.pe_user_id);
        initializer.setFirstName(dataSet.pe_first_name);
        initializer.setLastName(dataSet.pe_last_name);
        initializer.setEmail(dataSet.pe_email);
        initializer.setModifierUserId(dataSet.mod_user_id);
        initializer.setModifierFirstName(dataSet.mod_first_name);
        initializer.setModifierLastName(dataSet.mod_last_name);
        initializer.setModifierEmail(dataSet.mod_email);
        initializer.setRegistrationDate(dataSet.ds_registration_timestamp);
        initializer.setModificationDate(dataSet.ds_modification_timestamp);
        initializer.setAccessTimestamp(dataSet.access_timestamp);
        return new EntityRegistrationDetails(initializer);
    }

    private void enrichDataSetInitializersWithParents(List<DataSet.DataSetInitializer> dataSetInitializers, String[] dataSetCodes) {
        List<DataSetRelationRecord> dataSetRelations = this.query.getDataSetParentsCodes(dataSetCodes);
        if (dataSetRelations != null && !dataSetRelations.isEmpty()) {
            LinkedList<String> parentCodes;
            HashMap<String, LinkedList<String>> childCodeToParentCodesMap = new HashMap<String, LinkedList<String>>();
            for (DataSetRelationRecord dataSetRelation : dataSetRelations) {
                parentCodes = (LinkedList<String>)childCodeToParentCodesMap.get(dataSetRelation.dc_code);
                if (parentCodes == null) {
                    parentCodes = new LinkedList<String>();
                    childCodeToParentCodesMap.put(dataSetRelation.dc_code, parentCodes);
                }
                parentCodes.add(dataSetRelation.dp_code);
            }
            for (DataSet.DataSetInitializer dataSetInitializer : dataSetInitializers) {
                parentCodes = (List)childCodeToParentCodesMap.get(dataSetInitializer.getCode());
                dataSetInitializer.setParentCodes(parentCodes);
            }
        }
    }

    private void enrichDataSetInitializersWithChildren(List<DataSet.DataSetInitializer> dataSetInitializers, String[] dataSetCodes) {
        List<DataSetRelationRecord> dataSetRelations = this.query.getDataSetChildrenCodes(dataSetCodes);
        if (dataSetRelations != null && !dataSetRelations.isEmpty()) {
            LinkedList<String> childrenCodes;
            HashMap<String, LinkedList<String>> parentCodeToChildrenCodesMap = new HashMap<String, LinkedList<String>>();
            for (DataSetRelationRecord dataSetRelation : dataSetRelations) {
                childrenCodes = (LinkedList<String>)parentCodeToChildrenCodesMap.get(dataSetRelation.dp_code);
                if (childrenCodes == null) {
                    childrenCodes = new LinkedList<String>();
                    parentCodeToChildrenCodesMap.put(dataSetRelation.dp_code, childrenCodes);
                }
                childrenCodes.add(dataSetRelation.dc_code);
            }
            for (DataSet.DataSetInitializer dataSetInitializer : dataSetInitializers) {
                childrenCodes = (List)parentCodeToChildrenCodesMap.get(dataSetInitializer.getCode());
                dataSetInitializer.setChildrenCodes(childrenCodes);
            }
        }
    }

    @Override
    public List<DataStoreURLForDataSets> getDataStoreDownloadURLs(List<String> dataSetCodes) {
        String[] dataSetCodesArray = dataSetCodes.toArray(new String[dataSetCodes.size()]);
        List<DataSetDownloadRecord> records = this.query.getDownloadURLs(dataSetCodesArray);
        ArrayList<DataStoreURLForDataSets> result = new ArrayList<DataStoreURLForDataSets>(records.size());
        for (DataSetDownloadRecord r : records) {
            String[] dataSetCodeArray = StringUtils.split((String)r.data_set_codes.substring(1, r.data_set_codes.length() - 1), (char)',');
            result.add(new DataStoreURLForDataSets(r.url, dataSetCodeArray));
        }
        return result;
    }

    @Override
    public List<DataStoreURLForDataSets> getDataStoreRemoteURLs(List<String> dataSetCodes) {
        String[] dataSetCodesArray = dataSetCodes.toArray(new String[dataSetCodes.size()]);
        List<DataSetDownloadRecord> records = this.query.getRemoteURLs(dataSetCodesArray);
        ArrayList<DataStoreURLForDataSets> result = new ArrayList<DataStoreURLForDataSets>(records.size());
        for (DataSetDownloadRecord r : records) {
            String[] dataSetCodeArray = StringUtils.split((String)r.data_set_codes.substring(1, r.data_set_codes.length() - 1), (char)',');
            result.add(new DataStoreURLForDataSets(r.url, dataSetCodeArray));
        }
        return result;
    }
}

