/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.util;

import ch.systemsx.cisd.common.exceptions.InternalErr;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.SampleOwner;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.util.SpaceIdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.exception.UndefinedSpaceException;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;

public class SampleOwnerFinder {
    private final IAuthorizationDAOFactory daoFactory;
    private final PersonPE personPE;

    public SampleOwnerFinder(IAuthorizationDAOFactory daoFactory, PersonPE personPE) {
        assert (daoFactory != null) : "Unspecified DAOFactory";
        assert (personPE != null) : "Unspecified person";
        this.daoFactory = daoFactory;
        this.personPE = personPE;
    }

    public SampleOwner figureSampleOwner(SampleOwnerIdentifier owner) {
        SampleOwner ownerId = this.tryFigureSampleOwner(owner);
        if (ownerId == null) {
            throw UserFailureException.fromTemplate("Incorrect space or database name in '%s'", owner);
        }
        return ownerId;
    }

    public SampleOwner tryFigureSampleOwner(SampleOwnerIdentifier owner) {
        if (owner.isDatabaseInstanceLevel()) {
            DatabaseInstanceIdentifier databaseInstanceIdentifier = owner.getDatabaseInstanceLevel();
            return this.tryFigureSampleDatabaseOwner(databaseInstanceIdentifier);
        }
        if (owner.isSpaceLevel()) {
            return this.tryFigureSampleGroupOwner(owner);
        }
        throw InternalErr.error();
    }

    private SampleOwner tryFigureSampleGroupOwner(SampleOwnerIdentifier owner) {
        if (owner.isInsideHomeSpace()) {
            return this.createHomeGroupOwner(owner);
        }
        SpaceIdentifier spaceIdentifier = owner.getSpaceLevel();
        return this.tryFindAbsoluteGroupOwner(spaceIdentifier);
    }

    private SampleOwner tryFigureSampleDatabaseOwner(DatabaseInstanceIdentifier databaseInstanceIdentifier) {
        DatabaseInstancePE databaseInstance = SpaceIdentifierHelper.tryGetDatabaseInstance(databaseInstanceIdentifier, this.daoFactory);
        if (databaseInstance == null) {
            return null;
        }
        return SampleOwner.createDatabaseInstance(databaseInstance);
    }

    private SampleOwner tryFindAbsoluteGroupOwner(SpaceIdentifier spaceIdentifier) {
        SpacePE group = SpaceIdentifierHelper.tryGetSpace(spaceIdentifier, this.personPE, this.daoFactory);
        if (group == null) {
            return null;
        }
        return SampleOwner.createSpace(group);
    }

    private SampleOwner createHomeGroupOwner(SampleOwnerIdentifier identifier) {
        SpacePE homeGroup = this.personPE.getHomeSpace();
        if (homeGroup == null) {
            throw new UndefinedSpaceException();
        }
        return SampleOwner.createSpace(homeGroup);
    }
}

