/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.importer;

import ch.systemsx.cisd.args4j.Argument;
import ch.systemsx.cisd.args4j.CmdLineParser;
import ch.systemsx.cisd.args4j.ExampleMode;
import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import java.util.ArrayList;
import java.util.List;

final class Parameters {
    private static final String DEFAULT_UPLOAD_FOLDER = "temporary-upload-folder";
    private static final String DEFAULT_DATABASE_ENGINE = "postgresql";
    @Option(longName="upload-folder", metaVar="<path>", usage="Temporary folder for storing upload files. Default: temporary-upload-folder")
    private String uploadFolder;
    @Option(name="d", longName="database-instance-code", metaVar="CODE", usage="New database instance code of the database to be imported")
    private String databaseInstanceCode;
    @Option(longName="database engine", metaVar="postgresql|h2", usage="Code of the database engine. Default: postgresql")
    private String databaseEngine;
    @Argument
    private final List<String> arguments = new ArrayList<String>();
    private final CmdLineParser parser;
    private final IExitHandler exitHandler;

    Parameters(String[] args, IExitHandler exitHandler) {
        this.exitHandler = exitHandler;
        this.parser = new CmdLineParser((Object)this);
        this.parser.parseArgument(args);
        if (this.arguments.size() < 2) {
            this.printHelp(true);
        }
    }

    final String getUploadFolder() {
        return this.uploadFolder == null ? DEFAULT_UPLOAD_FOLDER : this.uploadFolder;
    }

    final String getDatabaseInstanceCode() {
        return this.databaseInstanceCode;
    }

    final String getDatabaseEngine() {
        return this.databaseEngine == null ? DEFAULT_DATABASE_ENGINE : this.databaseEngine;
    }

    @Option(name="h", longName="help", usage="Show this help text", skipForExample=true)
    public void printHelp(boolean exit) {
        this.parser.printHelp("java DatabaseInstanceImporter", "[option [...]]", "<database name> <dump file>", ExampleMode.ALL);
        if (exit) {
            this.exitHandler.exit(1);
        }
    }

    final String getDatabaseName() {
        return this.arguments.get(0);
    }

    final String getDumpFileName() {
        return this.arguments.get(1);
    }
}

