/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.reflection.AbstractHashable;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import java.io.Serializable;
import java.util.List;

public class ListSampleCriteriaDTO
extends AbstractHashable
implements Serializable {
    private static final long serialVersionUID = 35L;
    private List<SampleOwnerIdentifier> ownerIdentifiers;
    private SampleTypePE sampleType;
    private TechId containerSampleId;
    private TechId experimentId;
    private boolean excludeWithoutExperiment;
    private String baseIndexUrl;

    private ListSampleCriteriaDTO() {
    }

    public static final ListSampleCriteriaDTO createContainerSampleId(TechId containerSampleId) {
        ListSampleCriteriaDTO result = new ListSampleCriteriaDTO();
        result.containerSampleId = containerSampleId;
        return result;
    }

    public static final ListSampleCriteriaDTO createOwnerIdentifiers(List<SampleOwnerIdentifier> ownerIdentifiers, SampleTypePE sampleType) {
        ListSampleCriteriaDTO result = new ListSampleCriteriaDTO();
        result.ownerIdentifiers = ownerIdentifiers;
        result.sampleType = sampleType;
        return result;
    }

    public static final ListSampleCriteriaDTO createExperimentId(TechId experimentId) {
        ListSampleCriteriaDTO result = new ListSampleCriteriaDTO();
        result.experimentId = experimentId;
        return result;
    }

    public final TechId getContainerSampleId() {
        return this.containerSampleId;
    }

    public List<SampleOwnerIdentifier> getOwnerIdentifiers() {
        return this.ownerIdentifiers;
    }

    public SampleTypePE getSampleType() {
        return this.sampleType;
    }

    public TechId getExperimentId() {
        return this.experimentId;
    }

    public boolean isExcludeWithoutExperiment() {
        return this.excludeWithoutExperiment;
    }

    public void setExcludeWithoutExperiment(boolean excludeWithoutExperiment) {
        this.excludeWithoutExperiment = excludeWithoutExperiment;
    }

    public String getBaseIndexUrl() {
        return this.baseIndexUrl;
    }

    public void setBaseIndexUrl(String baseIndexUrl) {
        this.baseIndexUrl = baseIndexUrl;
    }
}

