/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.hibernate;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.springframework.orm.hibernate3.annotation.AnnotationSessionFactoryBean;

public class OpenbisAnnotationSessionFactoryBean
extends AnnotationSessionFactoryBean {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, OpenbisAnnotationSessionFactoryBean.class);

    protected void postProcessAnnotationConfiguration(AnnotationConfiguration config) throws HibernateException {
        String isAccessTimestampEnabled = System.getProperty("access-timestamp-enabled", "");
        if (isAccessTimestampEnabled.equals("true")) {
            operationLog.info((Object)"Enabling access timestamp column annotations");
        } else {
            this.removeAccessTimestampColumn(config);
            operationLog.info((Object)"Access timestamp column is not enabled. In order to use access_timestamp column you should apply the special database patch and set the java runtime property.\nin file servers/openBIS-server/jetty/etc/openbis.conf amend JAVA_OPTS with -Daccess-timestamp-enabled=true");
        }
    }

    private void removeAccessTimestampColumn(AnnotationConfiguration config) {
        Table table = config.getClassMapping(DataPE.class.getCanonicalName()).getRootClass().getTable();
        Iterator it = table.getColumnIterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            if (!column.getName().equals("access_timestamp")) continue;
            column.setName("modification_timestamp");
        }
    }
}

