/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.DisposableTabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.AbstractExternalDataGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetGridUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetProcessingMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DatastoreServiceDescriptionModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.ReportingPluginSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.report.ReportGeneratedCallback;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;

public abstract class AbstractDataSetsSection
extends DisposableTabContent {
    protected final ReportingPluginSelectionWidget reportSelectionWidget;
    protected final ReportGeneratedCallback.IOnReportComponentGeneratedAction reportGeneratedAction;
    private IDisposableComponent metadataComponent;

    public AbstractDataSetsSection(String header, IViewContext<?> viewContext, IIdHolder ownerIdOrNull) {
        super(header, viewContext, ownerIdOrNull);
        this.reportSelectionWidget = new ReportingPluginSelectionWidget(viewContext, ownerIdOrNull);
        this.reportGeneratedAction = new ReportGeneratedCallback.IOnReportComponentGeneratedAction(){

            @Override
            public void execute(IDisposableComponent gridComponent) {
                AbstractDataSetsSection.this.replaceContent(gridComponent);
            }
        };
        this.setIds(DisplayTypeIDGenerator.DATA_SETS_SECTION);
    }

    protected abstract IDisposableComponent createDatasetBrowserComponent();

    protected void initWidgets(AbstractExternalDataGrid browser) {
        this.getHeader().addTool((Component)this.reportSelectionWidget);
        if (!this.viewContext.isSimpleOrEmbeddedMode()) {
            DataSetGridUtils.IAddProcessingPluginsMenuAction addPluginsAction = new DataSetGridUtils.IAddProcessingPluginsMenuAction(){

                @Override
                public void addProcessingPlugins(DataSetProcessingMenu menu) {
                    AbstractDataSetsSection.this.getHeader().addTool((Component)new SeparatorToolItem());
                    AbstractDataSetsSection.this.getHeader().addTool((Component)menu);
                }
            };
            this.viewContext.getCommonService().listDataStoreServices(DataStoreServiceKind.PROCESSING, new DataSetGridUtils.LoadProcessingPluginsCallback(this.viewContext, browser, addPluginsAction));
        }
    }

    @Override
    protected final IDisposableComponent createDisposableContent() {
        this.metadataComponent = this.createDatasetBrowserComponent();
        this.initWidgets(DataSetGridUtils.extractBrowser(this.metadataComponent));
        SelectionChangedListener<DatastoreServiceDescriptionModel> reportChangedListener = DataSetGridUtils.createReportSelectionChangedListener(this.viewContext, this.metadataComponent, this.reportGeneratedAction);
        this.reportSelectionWidget.addSelectionChangedListener(reportChangedListener);
        return this.metadataComponent;
    }

    @Override
    protected final void replaceContent(IDisposableComponent content) {
        if (content != null) {
            this.removeAll();
            if (this.disposableComponentOrNull != null && !this.disposableComponentOrNull.getComponent().equals(this.metadataComponent.getComponent())) {
                super.disposeComponents();
            }
            this.updateContent(content, true);
        }
    }

    @Override
    public final void disposeComponents() {
        super.disposeComponents();
        if (this.metadataComponent != null) {
            this.metadataComponent.dispose();
        }
    }
}

