/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.FormPanelListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.UrlParamsHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file.BasicFileFieldManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WindowUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FormEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.form.FileUploadField;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public final class GenericDataSetBatchUpdateForm
extends AbstractRegistrationForm {
    private static final String PREFIX = "data-set-batch-update";
    public static final String ID = "openbis_data-set-batch-update";
    private static final String SESSION_KEY = "data-set-batch-update";
    private static final String FIELD_LABEL_TEMPLATE = "File";
    private static final int DEFAULT_NUMBER_OF_FILES = 1;
    private final BasicFileFieldManager fileFieldsManager;
    private final IViewContext<IGenericClientServiceAsync> viewContext;
    private final DataSetType dataSetType;

    public GenericDataSetBatchUpdateForm(IViewContext<IGenericClientServiceAsync> viewContext, DataSetType dataSetType) {
        super(viewContext.getCommonViewContext(), ID);
        this.setResetButtonVisible(true);
        this.viewContext = viewContext;
        this.dataSetType = dataSetType;
        this.fileFieldsManager = new BasicFileFieldManager("data-set-batch-update", 1, FIELD_LABEL_TEMPLATE);
        this.fileFieldsManager.setMandatory();
        this.setScrollMode(Style.Scroll.AUTO);
        this.addUploadFeatures("data-set-batch-update");
    }

    @Override
    protected void resetFieldsAfterSave() {
        for (FileUploadField attachmentField : this.fileFieldsManager.getFields()) {
            attachmentField.reset();
        }
        this.updateDirtyCheckAfterSave();
    }

    private final void addFormFields() {
        for (FileUploadField attachmentField : this.fileFieldsManager.getFields()) {
            this.formPanel.add((Widget)DatabaseModificationAwareField.wrapUnaware(attachmentField).get());
        }
        this.formPanel.add((Widget)this.createTemplateField());
        this.formPanel.addListener(Events.BeforeSubmit, (Listener)new Listener<FormEvent>(){

            public void handleEvent(FormEvent be) {
                GenericDataSetBatchUpdateForm.this.infoBox.displayProgress(GenericDataSetBatchUpdateForm.this.messageProvider.getMessage("progress_uploading", new Object[0]));
            }
        });
        this.formPanel.addListener(Events.Submit, new FormPanelListener(this.infoBox){

            @Override
            protected void onSuccessfullUpload() {
                GenericDataSetBatchUpdateForm.this.infoBox.displayProgress(GenericDataSetBatchUpdateForm.this.messageProvider.getMessage("progress_processing", new Object[0]));
                GenericDataSetBatchUpdateForm.this.save();
            }

            @Override
            protected void setUploadEnabled() {
                GenericDataSetBatchUpdateForm.this.setUploadEnabled(true);
            }
        });
        this.redefineSaveListeners();
    }

    protected void save() {
        this.viewContext.getService().updateDataSets(this.dataSetType, "data-set-batch-update", new UpdateDataSetsCallback(this.viewContext));
    }

    void redefineSaveListeners() {
        this.saveButton.removeAllListeners();
        this.addSaveButtonConfirmationListener();
        this.saveButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (GenericDataSetBatchUpdateForm.this.formPanel.isValid()) {
                    if (GenericDataSetBatchUpdateForm.this.fileFieldsManager.filesDefined() > 0) {
                        GenericDataSetBatchUpdateForm.this.setUploadEnabled(false);
                        GenericDataSetBatchUpdateForm.this.formPanel.submit();
                    } else {
                        GenericDataSetBatchUpdateForm.this.save();
                    }
                }
            }
        });
    }

    @Override
    protected final void submitValidForm() {
    }

    protected final void onRender(Element target, int index) {
        super.onRender(target, index);
        this.addFormFields();
    }

    private LabelField createTemplateField() {
        LabelField result = new LabelField(LinkRenderer.renderAsLink(this.viewContext.getMessage("file_template_label", new Object[0])));
        result.sinkEvents(1);
        result.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                WindowUtils.openWindow(UrlParamsHelper.createTemplateURL(EntityKind.DATA_SET, GenericDataSetBatchUpdateForm.this.dataSetType, false, true, BatchOperationKind.UPDATE));
            }
        });
        return result;
    }

    @Override
    protected void setUploadEnabled(boolean enabled) {
        super.setUploadEnabled(enabled);
        this.infoBoxResetListener.setEnabled(enabled);
    }

    private final class UpdateDataSetsCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<List<BatchRegistrationResult>> {
        UpdateDataSetsCallback(IViewContext<IGenericClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected String createSuccessfullRegistrationInfo(List<BatchRegistrationResult> result) {
            StringBuilder builder = new StringBuilder();
            for (BatchRegistrationResult batchRegistrationResult : result) {
                builder.append("<b>" + batchRegistrationResult.getFileName() + "</b>: ");
                builder.append(batchRegistrationResult.getMessage());
                builder.append("<br />");
            }
            return builder.toString();
        }
    }
}

