/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.UrlParamsHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.SpaceSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WindowUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.AbstractSampleBatchRegistrationForm;
import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public final class GenericSampleBatchRegistrationForm
extends AbstractSampleBatchRegistrationForm {
    private static final String SESSION_KEY = "sample-batch-registration";
    private final SampleType sampleType;
    private final CheckBoxField generateCodesCheckbox;
    private final CheckBoxField updateExistingCheckbox;
    private final SpaceSelectionWidget groupSelector;
    private final IViewContext<IGenericClientServiceAsync> viewContext;

    public GenericSampleBatchRegistrationForm(IViewContext<IGenericClientServiceAsync> viewContext, SampleType sampleType) {
        super(viewContext.getCommonViewContext(), SESSION_KEY);
        this.setResetButtonVisible(true);
        this.viewContext = viewContext;
        this.sampleType = sampleType;
        this.generateCodesCheckbox = new CheckBoxField(viewContext.getMessage("auto_generate_codes_label", new Object[0]), false);
        this.updateExistingCheckbox = new CheckBoxField(viewContext.getMessage("update_existing_entities_label", new Object[0]), false);
        this.groupSelector = this.createGroupField(viewContext.getCommonViewContext(), this.getId(), true, this.generateCodesCheckbox);
        this.generateCodesCheckbox.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

            public void handleEvent(FieldEvent be) {
                boolean selected = (Boolean)be.getValue();
                FieldUtil.setVisibility(selected, new Field[]{GenericSampleBatchRegistrationForm.this.groupSelector});
                if (selected) {
                    GenericSampleBatchRegistrationForm.this.updateExistingCheckbox.setValue(false);
                }
            }
        });
        this.updateExistingCheckbox.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

            public void handleEvent(FieldEvent be) {
                boolean selected = (Boolean)be.getValue();
                if (selected) {
                    GenericSampleBatchRegistrationForm.this.generateCodesCheckbox.setValue(false);
                }
            }
        });
    }

    @Override
    protected void save() {
        String defaultGroupIdentifier = null;
        Space selectedGroup = this.groupSelector.tryGetSelectedSpace();
        if (this.generateCodesCheckbox.getValue().booleanValue() && selectedGroup != null) {
            defaultGroupIdentifier = selectedGroup.getIdentifier();
        }
        boolean updateExisting = this.updateExistingCheckbox.getValue();
        this.viewContext.getService().registerSamples(this.sampleType, this.getSessionKey(), defaultGroupIdentifier, updateExisting, new RegisterSamplesCallback(this.viewContext));
    }

    @Override
    protected void addSpecificFormFields(FormPanel form) {
        form.add((Widget)this.generateCodesCheckbox);
        form.add((Widget)this.groupSelector);
        form.add((Widget)this.updateExistingCheckbox);
        form.add((Widget)this.createTemplateField());
    }

    @Override
    protected void resetPanel() {
        super.resetPanel();
        this.groupSelector.setVisible(false);
        this.groupSelector.setEnabled(false);
    }

    private LabelField createTemplateField() {
        LabelField result = new LabelField(LinkRenderer.renderAsLink(this.viewContext.getMessage("file_template_label", new Object[0])));
        result.sinkEvents(1);
        result.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                WindowUtils.openWindow(UrlParamsHelper.createTemplateURL(EntityKind.SAMPLE, GenericSampleBatchRegistrationForm.this.sampleType, GenericSampleBatchRegistrationForm.this.generateCodesCheckbox.getValue(), true, BatchOperationKind.REGISTRATION));
            }
        });
        return result;
    }

    private final SpaceSelectionWidget createGroupField(IViewContext<ICommonClientServiceAsync> context, String idSuffix, boolean addShared, final CheckBoxField checkbox) {
        SpaceSelectionWidget field = new SpaceSelectionWidget(context, idSuffix, addShared, false){

            protected boolean validateValue(String val) {
                if (checkbox.getValue().booleanValue() && this.tryGetSelectedSpace() == null) {
                    this.forceInvalid(GXT.MESSAGES.textField_blankText());
                    return false;
                }
                this.clearInvalid();
                return true;
            }
        };
        FieldUtil.markAsMandatory(field);
        field.setFieldLabel(this.viewContext.getMessage("default_group", new Object[0]));
        field.setVisible(false);
        return field;
    }

    private final class RegisterSamplesCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<List<BatchRegistrationResult>> {
        RegisterSamplesCallback(IViewContext<IGenericClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected String createSuccessfullRegistrationInfo(List<BatchRegistrationResult> result) {
            StringBuilder builder = new StringBuilder();
            for (BatchRegistrationResult batchRegistrationResult : result) {
                builder.append("<b>" + batchRegistrationResult.getFileName() + "</b>: ");
                builder.append(batchRegistrationResult.getMessage());
                builder.append("<br />");
            }
            return builder.toString();
        }
    }
}

