/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.ipfilter;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.ftpserver.ipfilter.IpFilter;
import org.apache.ftpserver.ipfilter.IpFilterType;
import org.apache.mina.filter.firewall.Subnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIpFilter
extends CopyOnWriteArraySet<Subnet>
implements IpFilter {
    Logger LOGGER = LoggerFactory.getLogger(DefaultIpFilter.class);
    private static final long serialVersionUID = 4887092372700628783L;
    private IpFilterType type = null;

    public DefaultIpFilter(IpFilterType type) {
        this(type, new HashSet(0));
    }

    public DefaultIpFilter(IpFilterType type, Collection<? extends Subnet> collection) {
        super(collection);
        this.type = type;
    }

    public DefaultIpFilter(IpFilterType type, String addresses) throws NumberFormatException, UnknownHostException {
        this.type = type;
        if (addresses != null) {
            String[] tokens;
            for (String token : tokens = addresses.split("[\\s,]+")) {
                if (token.trim().length() <= 0) continue;
                this.add(token);
            }
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Created DefaultIpFilter of type {} with the subnets {}", (Object)type, (Object)this);
        }
    }

    public IpFilterType getType() {
        return this.type;
    }

    public void setType(IpFilterType type) {
        this.type = type;
    }

    @Override
    public boolean add(String str) throws NumberFormatException, UnknownHostException {
        if (str.trim().length() < 1) {
            throw new IllegalArgumentException("Invalid IP Address or Subnet: " + str);
        }
        String[] tokens = str.split("/");
        if (tokens.length == 2) {
            return this.add(new Subnet(InetAddress.getByName(tokens[0]), Integer.parseInt(tokens[1])));
        }
        return this.add(new Subnet(InetAddress.getByName(tokens[0]), 32));
    }

    @Override
    public boolean accept(InetAddress address) {
        switch (this.type) {
            case ALLOW: {
                for (Subnet subnet : this) {
                    if (!subnet.inSubnet(address)) continue;
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug("Allowing connection from {} because it matches with the whitelist subnet {}", new Object[]{address, subnet});
                    }
                    return true;
                }
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("Denying connection from {} because it does not match any of the whitelist subnets", new Object[]{address});
                }
                return false;
            }
            case DENY: {
                if (this.isEmpty()) {
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug("Allowing connection from {} because blacklist is empty", new Object[]{address});
                    }
                    return true;
                }
                for (Subnet subnet : this) {
                    if (!subnet.inSubnet(address)) continue;
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug("Denying connection from {} because it matches with the blacklist subnet {}", new Object[]{address, subnet});
                    }
                    return false;
                }
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("Allowing connection from {} because it does not match any of the blacklist subnets", new Object[]{address});
                }
                return true;
            }
        }
        throw new RuntimeException("Unknown or unimplemented filter type: " + (Object)((Object)this.type));
    }
}

