/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.PGResultSetMetaData;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.Field;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc2ResultSetMetaData
implements PGResultSetMetaData {
    protected final BaseConnection connection;
    protected final Field[] fields;
    private boolean fieldInfoFetched;

    public AbstractJdbc2ResultSetMetaData(BaseConnection connection, Field[] fields) {
        this.connection = connection;
        this.fields = fields;
        this.fieldInfoFetched = false;
    }

    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        return field.getAutoIncrement();
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        Field field = this.getField(column);
        return this.connection.getTypeInfo().isCaseSensitive(field.getOID());
    }

    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    public boolean isCurrency(int column) throws SQLException {
        String type_name = this.getPGType(column);
        return type_name.equals("cash") || type_name.equals("money");
    }

    public int isNullable(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        return field.getNullable();
    }

    public boolean isSigned(int column) throws SQLException {
        Field field = this.getField(column);
        return this.connection.getTypeInfo().isSigned(field.getOID());
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        Field field = this.getField(column);
        return this.connection.getTypeInfo().getDisplaySize(field.getOID(), field.getMod());
    }

    public String getColumnLabel(int column) throws SQLException {
        Field field = this.getField(column);
        return field.getColumnLabel();
    }

    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    @Override
    public String getBaseColumnName(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        return field.getColumnName();
    }

    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    private void fetchFieldMetaData() throws SQLException {
        if (this.fieldInfoFetched) {
            return;
        }
        this.fieldInfoFetched = true;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT c.oid, a.attnum, a.attname, c.relname, n.nspname, ");
        sql.append("a.attnotnull OR (t.typtype = 'd' AND t.typnotnull), ");
        sql.append("pg_catalog.pg_get_expr(d.adbin, d.adrelid) LIKE '%nextval(%' ");
        sql.append("FROM pg_catalog.pg_class c ");
        sql.append("JOIN pg_catalog.pg_namespace n ON (c.relnamespace = n.oid) ");
        sql.append("JOIN pg_catalog.pg_attribute a ON (c.oid = a.attrelid) ");
        sql.append("JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid) ");
        sql.append("LEFT JOIN pg_catalog.pg_attrdef d ON (d.adrelid = a.attrelid AND d.adnum = a.attnum) ");
        sql.append("JOIN (");
        boolean hasSourceInfo = false;
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getTableOid() == 0) continue;
            if (hasSourceInfo) {
                sql.append(" UNION ALL ");
            }
            sql.append("SELECT ");
            sql.append(this.fields[i].getTableOid());
            if (!hasSourceInfo) {
                sql.append(" AS oid ");
            }
            sql.append(", ");
            sql.append(this.fields[i].getPositionInTable());
            if (!hasSourceInfo) {
                sql.append(" AS attnum");
            }
            if (hasSourceInfo) continue;
            hasSourceInfo = true;
        }
        sql.append(") vals ON (c.oid = vals.oid AND a.attnum = vals.attnum) ");
        if (!hasSourceInfo) {
            return;
        }
        Statement stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery(sql.toString());
        while (rs.next()) {
            int table = (int)rs.getLong(1);
            int column = (int)rs.getLong(2);
            String columnName = rs.getString(3);
            String tableName = rs.getString(4);
            String schemaName = rs.getString(5);
            int nullable = rs.getBoolean(6) ? 0 : 1;
            boolean autoIncrement = rs.getBoolean(7);
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i].getTableOid() != table || this.fields[i].getPositionInTable() != column) continue;
                this.fields[i].setColumnName(columnName);
                this.fields[i].setTableName(tableName);
                this.fields[i].setSchemaName(schemaName);
                this.fields[i].setNullable(nullable);
                this.fields[i].setAutoIncrement(autoIncrement);
            }
        }
    }

    @Override
    public String getBaseSchemaName(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        return field.getSchemaName();
    }

    public int getPrecision(int column) throws SQLException {
        Field field = this.getField(column);
        return this.connection.getTypeInfo().getPrecision(field.getOID(), field.getMod());
    }

    public int getScale(int column) throws SQLException {
        Field field = this.getField(column);
        return this.connection.getTypeInfo().getScale(field.getOID(), field.getMod());
    }

    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getBaseTableName(int column) throws SQLException {
        this.fetchFieldMetaData();
        Field field = this.getField(column);
        return field.getTableName();
    }

    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        return this.getSQLType(column);
    }

    @Override
    public int getFormat(int column) throws SQLException {
        return this.getField(column).getFormat();
    }

    public String getColumnTypeName(int column) throws SQLException {
        String type = this.getPGType(column);
        if (this.isAutoIncrement(column)) {
            if ("int4".equals(type)) {
                return "serial";
            }
            if ("int8".equals(type)) {
                return "bigserial";
            }
        }
        return type;
    }

    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    protected Field getField(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(columnIndex), new Integer(this.fields.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return this.fields[columnIndex - 1];
    }

    protected String getPGType(int columnIndex) throws SQLException {
        return this.connection.getTypeInfo().getPGType(this.getField(columnIndex).getOID());
    }

    protected int getSQLType(int columnIndex) throws SQLException {
        return this.connection.getTypeInfo().getSQLType(this.getField(columnIndex).getOID());
    }

    public String getColumnClassName(int column) throws SQLException {
        Field field = this.getField(column);
        String result = this.connection.getTypeInfo().getJavaClass(field.getOID());
        if (result != null) {
            return result;
        }
        int sqlType = this.getSQLType(column);
        switch (sqlType) {
            case 2003: {
                return "java.sql.Array";
            }
        }
        String type = this.getPGType(column);
        if ("unknown".equals(type)) {
            return "java.lang.String";
        }
        return "java.lang.Object";
    }
}

