/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.ByteBufferRandomAccessFile;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.base.io.RandomAccessFileImpl;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.IReadParams;
import ch.systemsx.cisd.imagereaders.ImageID;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class AbstractImageReader
implements IImageReader {
    private final String libraryName;
    private final String readerName;

    public AbstractImageReader(String libraryName, String readerName) {
        this.libraryName = libraryName;
        this.readerName = readerName;
    }

    @Override
    public String getLibraryName() {
        return this.libraryName;
    }

    @Override
    public String getName() {
        return this.readerName;
    }

    @Override
    public final List<ImageID> getImageIDs(File file) throws IOExceptionUnchecked {
        RandomAccessFileImpl raf = new RandomAccessFileImpl(file, "r");
        try {
            List<ImageID> list = this.getImageIDs((IRandomAccessFile)raf);
            return list;
        }
        finally {
            raf.close();
        }
    }

    @Override
    public final List<ImageID> getImageIDs(byte[] bytes) {
        return this.getImageIDs((IRandomAccessFile)new ByteBufferRandomAccessFile(bytes));
    }

    @Override
    public List<ImageID> getImageIDs(IRandomAccessFile handle) throws IOExceptionUnchecked {
        return Arrays.asList(ImageID.NULL);
    }

    @Override
    public BufferedImage readImage(File file, ImageID imageID, IReadParams params) throws IOExceptionUnchecked {
        RandomAccessFileImpl raf = new RandomAccessFileImpl(file, "r");
        try {
            BufferedImage bufferedImage = this.readImage((IRandomAccessFile)raf, imageID, params);
            return bufferedImage;
        }
        finally {
            raf.close();
        }
    }

    @Override
    public BufferedImage readImage(byte[] bytes, ImageID imageID, IReadParams params) {
        ByteBufferRandomAccessFile raf = new ByteBufferRandomAccessFile(bytes);
        return this.readImage((IRandomAccessFile)raf, imageID, params);
    }

    @Override
    public boolean isMetaDataAware() {
        return false;
    }

    @Override
    public Map<String, Object> readMetaData(File file, ImageID imageID, IReadParams params) throws IOExceptionUnchecked {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> readMetaData(byte[] bytes, ImageID imageID, IReadParams params) {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> readMetaData(IRandomAccessFile handle, ImageID imageID, IReadParams params) {
        return Collections.emptyMap();
    }
}

