/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.IImageReaderLibrary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;

public class ImageReaderFactory {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ImageReaderFactory.class);
    private static List<IImageReaderLibrary> libraries = ImageReaderFactory.getAvailableReaders();

    private static List<IImageReaderLibrary> getAvailableReaders() {
        try {
            Iterator<IImageReaderLibrary> librariesIterator = ServiceLoader.load(IImageReaderLibrary.class).iterator();
            return CollectionUtils.asList(librariesIterator);
        }
        catch (NoClassDefFoundError ex) {
            operationLog.warn((Object)"Image reader plugins not available (JRE < 1.6), fallback to built-in readers.", (Throwable)ex);
            return ImageReaderFactory.getBuiltInReaders();
        }
    }

    private static List<IImageReaderLibrary> getBuiltInReaders() {
        ArrayList<IImageReaderLibrary> readers = new ArrayList<IImageReaderLibrary>();
        IImageReaderLibrary reader = ImageReaderFactory.tryCreateReader("ch.systemsx.cisd.imagereaders.imageio.ImageIOReaderLibrary");
        if (reader != null) {
            readers.add(reader);
        }
        if ((reader = ImageReaderFactory.tryCreateReader("ch.systemsx.cisd.imagereaders.ij.ImageJReaderLibrary")) != null) {
            readers.add(reader);
        }
        if ((reader = ImageReaderFactory.tryCreateReader("ch.systemsx.cisd.imagereaders.jai.JAIReaderLibrary")) != null) {
            readers.add(reader);
        }
        if ((reader = ImageReaderFactory.tryCreateReader("ch.systemsx.cisd.imagereaders.bioformats.BioFormatsReaderLibrary")) != null) {
            readers.add(reader);
        }
        return readers;
    }

    private static IImageReaderLibrary tryCreateReader(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (IImageReaderLibrary)ClassUtils.create(IImageReaderLibrary.class, clazz, (Object[])new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static List<IImageReaderLibrary> getLibraries() {
        return libraries;
    }

    public static IImageReader tryGetReader(String libraryName, String readerName) {
        IImageReaderLibrary library = ImageReaderFactory.findLibrary(libraryName);
        return library == null ? null : library.tryGetReader(readerName);
    }

    public static IImageReader tryGetReaderForFile(String libraryName, String fileName) {
        IImageReaderLibrary library = ImageReaderFactory.findLibrary(libraryName);
        return library == null ? null : library.tryGetReaderForFile(fileName);
    }

    public static IImageReader tryGetReaderForFile(String fileName) {
        for (IImageReaderLibrary library : libraries) {
            IImageReader imageReader = library.tryGetReaderForFile(fileName);
            if (imageReader == null) continue;
            return imageReader;
        }
        return null;
    }

    private static IImageReaderLibrary findLibrary(String libraryName) throws IllegalArgumentException {
        for (IImageReaderLibrary library : libraries) {
            if (!library.getName().equalsIgnoreCase(libraryName)) continue;
            return library;
        }
        return null;
    }

    static void setLibraries(List<IImageReaderLibrary> newLibraries) {
        libraries = newLibraries;
    }
}

