/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.grid;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ColumnModelEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.SplitButton;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.menu.CheckMenuItem;
import com.extjs.gxt.ui.client.widget.menu.Menu;

class ColumnMenu
extends SplitButton {
    public <M extends ModelData> ColumnMenu(String label, ColumnModel columnModel) {
        super(label);
        Menu columnMenu = new Menu();
        int colIndex = 0;
        while (colIndex < columnModel.getColumnCount()) {
            if (!columnModel.isFixed(colIndex)) {
                CheckMenuItem menuItem = new CheckMenuItem(columnModel.getColumnHeader(colIndex));
                menuItem.setHideOnClick(false);
                menuItem.setChecked(!columnModel.isHidden(colIndex));
                ColumnMenu.bindMenuItemWithColumn(columnModel, menuItem, colIndex, columnMenu);
                columnMenu.add((Component)menuItem);
            }
            ++colIndex;
        }
        this.setMenu(columnMenu);
    }

    private static void bindMenuItemWithColumn(final ColumnModel columnModel, final CheckMenuItem menuItem, final int colIndex, final Menu columnMenu) {
        columnModel.addListener(Events.HiddenChange, (Listener)new Listener<ColumnModelEvent>(){

            public void handleEvent(ColumnModelEvent be) {
                if (be.getColIndex() == colIndex) {
                    menuItem.setChecked(!columnModel.isHidden(colIndex), false);
                }
            }
        });
        menuItem.addSelectionListener((SelectionListener)new SelectionListener<MenuEvent>(){

            public void componentSelected(MenuEvent ce) {
                columnModel.setHidden(colIndex, !menuItem.isChecked());
                ColumnMenu.restrictMenu(columnMenu, columnModel);
            }
        });
    }

    private static void restrictMenu(Menu columns, ColumnModel columnModel) {
        int count = 0;
        int i = 0;
        while (i < columnModel.getColumnCount()) {
            if (!columnModel.isHidden(i) && !columnModel.isFixed(i)) {
                ++count;
            }
            ++i;
        }
        if (count == 1) {
            for (Component item : columns.getItems()) {
                CheckMenuItem checkItem = (CheckMenuItem)item;
                if (!checkItem.isChecked()) continue;
                checkItem.disable();
            }
        } else {
            for (Component item : columns.getItems()) {
                item.enable();
            }
        }
    }
}

