/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.ui;

import ch.systemsx.cisd.cifex.client.ICIFEXServiceAsync;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.ui.UserTextArea;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.DateField;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import java.util.Date;

public final class EditFileWidget
extends LayoutContainer {
    public static final int WIDTH = 600;
    public static final int LABEL_WIDTH = 100;
    private static final int COMMENT_AREA_HEIGHT = 100;
    private final ViewContext context;
    private final FormPanel formPanel;
    private final FormData formData;
    private TextField<String> fileNameField;
    private TextArea commentField;
    private DateField expirationDateField;
    protected final FileInfoDTO editFile;

    public EditFileWidget(ViewContext context, FileInfoDTO file) {
        this.context = context;
        this.editFile = file;
        this.formData = new FormData("-20");
        this.formPanel = this.createEditFileForm();
        this.add((Component)this.formPanel);
    }

    private FormPanel createEditFileForm() {
        FormPanel newFormPanel = new FormPanel();
        newFormPanel.setHeaderVisible(false);
        newFormPanel.setFrame(false);
        newFormPanel.setBodyBorder(false);
        newFormPanel.setBorders(false);
        newFormPanel.setButtonAlign(Style.HorizontalAlignment.CENTER);
        newFormPanel.setBorders(false);
        newFormPanel.setScrollMode(Style.Scroll.AUTO);
        newFormPanel.setWidth(600);
        newFormPanel.setLabelWidth(100);
        this.fileNameField = this.createFileNameField();
        newFormPanel.add(this.fileNameField, (LayoutData)this.formData);
        this.commentField = this.createCommentField();
        newFormPanel.add((Widget)this.commentField, (LayoutData)this.formData);
        this.expirationDateField = this.createExpirationDateField();
        newFormPanel.add((Widget)this.expirationDateField, (LayoutData)this.formData);
        return newFormPanel;
    }

    private TextField<String> createFileNameField() {
        TextField fieldConfig = new TextField();
        fieldConfig.setFieldLabel(MessageDictionary.msg(MessageDictionary.LIST_FILES_NAME_COLUMN_HEADER));
        fieldConfig.setName("file-name");
        fieldConfig.setAllowBlank(false);
        fieldConfig.setValue((Object)this.editFile.getName());
        return fieldConfig;
    }

    private final TextArea createCommentField() {
        UserTextArea textAreaConfig = new UserTextArea();
        textAreaConfig.setAllowBlank(true);
        textAreaConfig.setFieldLabel(MessageDictionary.msg(MessageDictionary.LIST_FILES_COMMENT_COLUMN_HEADER));
        textAreaConfig.setName("file-comment");
        textAreaConfig.setHeight(100);
        textAreaConfig.setValue(this.editFile.getComment());
        return textAreaConfig;
    }

    private final DateField createExpirationDateField() {
        DateField dateField = new DateField();
        dateField.setFieldLabel(MessageDictionary.msg(MessageDictionary.EDIT_FILE_EXPIRATION_DATE_LABEL));
        long registrationTimeOrNow = this.editFile.getRegistrationDate().getTime();
        Date minExpirationDate = new Date(registrationTimeOrNow);
        CalendarUtil.addDaysToDate((Date)minExpirationDate, (int)1);
        dateField.setMinValue(minExpirationDate);
        if (!this.context.getModel().getUser().isAdmin()) {
            Date maxExpirationDate = new Date(registrationTimeOrNow);
            CalendarUtil.addDaysToDate((Date)maxExpirationDate, (int)this.context.getModel().getUser().getMaxFileRetention());
            dateField.setMaxValue(maxExpirationDate);
        }
        dateField.getPropertyEditor().setFormat(DateTimeFormat.getFormat((String)"yyyy-MM-dd"));
        dateField.setAllowBlank(false);
        dateField.setValue((Object)this.editFile.getExpirationDate());
        return dateField;
    }

    public void submitForm(Button button, AsyncCallback<Date> refreshCallback) {
        ICIFEXServiceAsync cifexService = this.context.getCifexService();
        if (this.formPanel.isValid()) {
            if (button != null) {
                button.disable();
            }
            String name = (String)this.fileNameField.getValue();
            String comment = (String)this.commentField.getValue();
            Date expirationDate = (Date)this.expirationDateField.getValue();
            cifexService.updateFileUserData(this.editFile.getID(), name, comment, expirationDate, refreshCallback);
        } else {
            MessageBox.alert((String)MessageDictionary.msg(MessageDictionary.MESSAGE_BOX_ERROR_TITLE), (String)MessageDictionary.msg(MessageDictionary.CREATE_USER_INVALID_DATA_MSG), null);
        }
    }
}

