/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.impl;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.ParseException;
import java.util.IdentityHashMap;
import java.util.Map;
import net.lemnik.eodsql.Call;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.EoDException;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.impl.AbstractMethodImplementation;
import net.lemnik.eodsql.spi.Context;
import net.lemnik.eodsql.spi.MethodImplementation;
import net.lemnik.eodsql.spi.MethodImplementationFactory;
import net.lemnik.eodsql.spi.ResultSetResource;
import net.lemnik.eodsql.spi.StatementResource;
import net.lemnik.eodsql.spi.util.NoDataObjectBinding;
import net.lemnik.eodsql.spi.util.Query;
import net.lemnik.eodsql.spi.util.ResultSetWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CallMethodImplementation
extends AbstractMethodImplementation<Call> {
    private final boolean returnVoid;

    CallMethodImplementation(Method method) throws ParseException {
        Call call = method.getAnnotation(Call.class);
        String queryString = call.value();
        if (queryString.length() == 0) {
            queryString = call.call();
        }
        this.query = Query.getQuery(queryString, method.getParameterTypes());
        this.setParameterMappers(call.parameterBindings());
        boolean bl = this.returnVoid = method.getReturnType() == Void.TYPE;
        if (!this.returnVoid) {
            Map<String, Object> parameters = CallMethodImplementation.extractReturnTypeParameters(call);
            this.wrapper = ResultSetWrapper.get(method.getGenericReturnType(), parameters);
        }
    }

    private static Map<String, Object> extractReturnTypeParameters(Call call) {
        IdentityHashMap<String, Object> parameters = new IdentityHashMap<String, Object>(4);
        if (call.disconnected()) {
            parameters.put("net.lemnik.eodsql.spi.util.DataSetWrapper#disconnected", Boolean.TRUE);
        } else {
            parameters.put("net.lemnik.eodsql.spi.util.DataSetWrapper#disconnected", Boolean.FALSE);
        }
        if (call.readOnly()) {
            parameters.put("net.lemnik.eodsql.spi.util.DataSetWrapper#updatable", Boolean.FALSE);
        } else {
            parameters.put("net.lemnik.eodsql.spi.util.DataSetWrapper#updatable", Boolean.TRUE);
        }
        if (call.rubberstamp()) {
            parameters.put("net.elmnik.eodsql.spi.util.DataIteratorWrapper#rubberstamp", Boolean.TRUE);
        } else {
            parameters.put("net.elmnik.eodsql.spi.util.DataIteratorWrapper#rubberstamp", Boolean.FALSE);
        }
        if (call.resultSetBinding() != NoDataObjectBinding.class) {
            try {
                parameters.put("net.lemnik.eodsql.spi.util.ResultSetWrapper#binding", call.resultSetBinding().newInstance());
            }
            catch (Exception ex) {
                throw new InvalidQueryException("DataObjectBinding classes must have a default (null) constructor: " + call.resultSetBinding().getCanonicalName(), ex);
            }
        }
        parameters.put("net.lemnik.eodsql.spi.util.DataSetWrapper#cacheClass", call.cache());
        return parameters;
    }

    @Override
    public void invoke(Context<Call> context) throws Throwable {
        Connection connection = context.getResource(Connection.class).get();
        CallableStatement statement = this.returnVoid ? connection.prepareCall(this.query.toString()) : connection.prepareCall(this.query.toString(), this.wrapper.getPreferredResultSetType(), this.wrapper.getPreferredResultSetConcurrency());
        this.fillPreparedStatementParameters(context, statement);
        context.setResource(new StatementResource(statement));
        if (statement.execute()) {
            ResultSet results = statement.getResultSet();
            context.setResource(new ResultSetResource(results));
            if (!this.returnVoid) {
                context.setReturnValue(this.wrapper.wrap(context));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Factory
    implements MethodImplementationFactory<Call> {
        Factory() {
        }

        @Override
        public void validate(Method method) throws InvalidQueryException {
            Call call = method.getAnnotation(Call.class);
            String sql = call.value();
            if (sql.length() == 0) {
                sql = call.call();
            }
            if (sql.length() == 0) {
                throw new InvalidQueryException("No EoD SQL Query in Call annotation", method);
            }
            Query.validate(sql, method);
            if (call.rubberstamp() && method.getReturnType() != DataIterator.class) {
                throw new InvalidQueryException("A rubberstamping Select must return a DataIterator", method);
            }
            if (method.getReturnType() != Void.TYPE) {
                ResultSetWrapper.validate(method.getGenericReturnType());
            }
        }

        @Override
        public MethodImplementation<Call> createImplementation(Method method) {
            try {
                return new CallMethodImplementation(method);
            }
            catch (ParseException pe) {
                throw new EoDException(pe);
            }
        }
    }
}

