/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.impl;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.lemnik.eodsql.EoDException;
import net.lemnik.eodsql.impl.BaseQueryImpl;
import net.lemnik.eodsql.impl.ExceptionTranslator;

public class ExceptionTranslationUtils {
    private static ExceptionTranslator exceptionTranslator = new DefaultExceptionTranslator();

    public static boolean isDefaultTranslator() {
        return exceptionTranslator instanceof DefaultExceptionTranslator;
    }

    public static void setExceptionTranslator(ExceptionTranslator exceptionTranslator) {
        ExceptionTranslationUtils.exceptionTranslator = exceptionTranslator;
    }

    public static RuntimeException translateException(BaseQueryImpl.ConnectionSource connectionSource, Method method, Object[] objectArray, BaseQueryImpl.Callable callable, Exception exception) {
        return ExceptionTranslationUtils.translateException(connectionSource, method.getName(), ExceptionTranslationUtils.getSql(callable, method, objectArray), exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RuntimeException translateException(BaseQueryImpl.ConnectionSource connectionSource, String string, String string2, Exception exception) {
        if (connectionSource instanceof BaseQueryImpl.DataSourceConnectionSource) {
            DataSource dataSource = ((BaseQueryImpl.DataSourceConnectionSource)connectionSource).getDataSource();
            return ExceptionTranslationUtils.translateException(dataSource, string, string2, exception);
        }
        Connection connection = null;
        try {
            connection = connectionSource.getConnection();
            RuntimeException runtimeException = ExceptionTranslationUtils.translateException(connection, string, string2, exception);
            return runtimeException;
        }
        catch (SQLException sQLException) {
            EoDException eoDException = new EoDException(ExceptionTranslationUtils.toMessage(string, string2), exception);
            return eoDException;
        }
        finally {
            if (connection != null) {
                try {
                    connectionSource.releaseConnection(connection);
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static RuntimeException translateException(DataSource dataSource, String string, String string2, Exception exception) {
        if (exception instanceof SQLException) {
            return exceptionTranslator.translateException(dataSource, string, string2, (SQLException)exception);
        }
        return new EoDException(ExceptionTranslationUtils.toMessage(string, string2), exception);
    }

    public static RuntimeException translateException(Connection connection, String string, String string2, Exception exception) {
        if (exception instanceof SQLException) {
            return exceptionTranslator.translateException(connection, string, string2, (SQLException)exception);
        }
        return new EoDException(ExceptionTranslationUtils.toMessage(string, string2), exception);
    }

    public static RuntimeException uniqueResultExpected() {
        return exceptionTranslator.uniqueResultExpected();
    }

    private static String toMessage(String string, String string2) {
        return string + "[SQL: '" + string2 + "'].";
    }

    private static String getSql(BaseQueryImpl.Callable callable, Method method, Object[] objectArray) {
        if (callable instanceof BaseQueryImpl.SQLCallable) {
            return ((BaseQueryImpl.SQLCallable)callable).getSQL(method, objectArray);
        }
        return "?";
    }

    private static class DefaultExceptionTranslator
    implements ExceptionTranslator {
        private DefaultExceptionTranslator() {
        }

        public RuntimeException translateException(DataSource dataSource, String string, String string2, SQLException sQLException) {
            return new EoDException("'" + string + "' [SQL: '" + string2 + "']", sQLException);
        }

        public RuntimeException translateException(Connection connection, String string, String string2, SQLException sQLException) {
            return new EoDException("'" + string + "' [SQL: '" + string2 + "']", sQLException);
        }

        public RuntimeException uniqueResultExpected() {
            return new EoDException("A unique result was expected but the database returned multiple rows.");
        }
    }
}

