/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.ParseException;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.DataSet;
import net.lemnik.eodsql.EoDException;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.Select;
import net.lemnik.eodsql.impl.SelectIntoMethodImplementation;
import net.lemnik.eodsql.impl.SelectMethodImplementation;
import net.lemnik.eodsql.spi.MethodImplementation;
import net.lemnik.eodsql.spi.MethodImplementationFactory;
import net.lemnik.eodsql.spi.util.DataObjectBinding;
import net.lemnik.eodsql.spi.util.Query;
import net.lemnik.eodsql.spi.util.ResultSetWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectMethodImplementationFactory
implements MethodImplementationFactory<Select> {
    SelectMethodImplementationFactory() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validate(Method method) throws InvalidQueryException {
        Select select = method.getAnnotation(Select.class);
        String string = select.value();
        if (string.length() == 0) {
            string = select.sql();
        }
        if (string.length() == 0) {
            throw new InvalidQueryException("No EoD SQL Query in Select annotation", method);
        }
        Query.validate(string, method);
        Type type = method.getGenericReturnType();
        Type[] typeArray = method.getGenericParameterTypes();
        if (select.into() > 0 && select.into() <= typeArray.length) {
            Type type2 = typeArray[select.into() - 1];
            if (!type.equals(Void.TYPE) && !type.equals(type2)) {
                throw new InvalidQueryException("@Select(into) for parameter type " + typeArray[select.into() - 1] + " cannot return " + type, method);
            }
            if (!(type2 instanceof Class)) throw new InvalidQueryException("@Select(into) requires a valid, concrete data object type to select into: " + type2, method);
            DataObjectBinding.validate((Class)type2);
            return;
        } else {
            if (select.into() != 0) throw new InvalidQueryException("Invalid parameter index to select into: " + select.into(), method);
            if (type.equals(DataSet.class) && select.disconnected() && !select.readOnly()) {
                throw new InvalidQueryException("A disconnected Select may not be writable.", method);
            }
            if (select.rubberstamp() && !type.equals(DataIterator.class)) {
                throw new InvalidQueryException("A rubberstamping Select must return a DataIterator", method);
            }
            ResultSetWrapper.validate(type);
        }
    }

    @Override
    public MethodImplementation<Select> createImplementation(Method method) {
        try {
            Select select = method.getAnnotation(Select.class);
            if (select.into() <= 0) {
                return new SelectMethodImplementation(method);
            }
            return new SelectIntoMethodImplementation(method);
        }
        catch (ParseException parseException) {
            throw new EoDException(parseException);
        }
    }
}

