/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.PoolableCallableStatement;
import org.apache.commons.dbcp.PoolablePreparedStatement;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

public class PoolingConnection
extends DelegatingConnection
implements Connection,
KeyedPoolableObjectFactory {
    protected KeyedObjectPool _pstmtPool = null;
    private static final byte STATEMENT_PREPAREDSTMT = 0;
    private static final byte STATEMENT_CALLABLESTMT = 1;

    public PoolingConnection(Connection connection) {
        super(connection);
    }

    public PoolingConnection(Connection connection, KeyedObjectPool keyedObjectPool) {
        super(connection);
        this._pstmtPool = keyedObjectPool;
    }

    public synchronized void close() throws SQLException {
        if (null != this._pstmtPool) {
            KeyedObjectPool keyedObjectPool = this._pstmtPool;
            this._pstmtPool = null;
            try {
                keyedObjectPool.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw (SQLException)new SQLException("Cannot close connection").initCause(exception);
            }
        }
        this.getInnermostDelegate().close();
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return (PreparedStatement)this._pstmtPool.borrowObject(this.createKey(string));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw (SQLException)new SQLException("MaxOpenPreparedStatements limit reached").initCause(noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow prepareStatement from pool failed", exception);
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return (PreparedStatement)this._pstmtPool.borrowObject(this.createKey(string, n, n2));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw (SQLException)new SQLException("MaxOpenPreparedStatements limit reached").initCause(noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Borrow prepareStatement from pool failed").initCause(exception);
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        try {
            return (CallableStatement)this._pstmtPool.borrowObject(this.createKey(string, (byte)1));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLNestedException("MaxOpenCallableStatements limit reached", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow callableStatement from pool failed", exception);
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            return (CallableStatement)this._pstmtPool.borrowObject(this.createKey(string, n, n2, (byte)1));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLNestedException("MaxOpenCallableStatements limit reached", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Borrow callableStatement from pool failed", exception);
        }
    }

    protected Object createKey(String string, int n, int n2) {
        String string2 = null;
        try {
            string2 = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(string), string2, n, n2);
    }

    protected Object createKey(String string, int n, int n2, byte by) {
        String string2 = null;
        try {
            string2 = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(string), string2, n, n2, by);
    }

    protected Object createKey(String string) {
        String string2 = null;
        try {
            string2 = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(string), string2);
    }

    protected Object createKey(String string, byte by) {
        String string2 = null;
        try {
            string2 = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new PStmtKey(this.normalizeSQL(string), string2, by);
    }

    protected String normalizeSQL(String string) {
        return string.trim();
    }

    public Object makeObject(Object object) throws Exception {
        if (null == object || !(object instanceof PStmtKey)) {
            throw new IllegalArgumentException("Prepared statement key is null or invalid.");
        }
        PStmtKey pStmtKey = (PStmtKey)object;
        if (null == pStmtKey._resultSetType && null == pStmtKey._resultSetConcurrency) {
            if (pStmtKey._stmtType == 0) {
                return new PoolablePreparedStatement(this.getDelegate().prepareStatement(pStmtKey._sql), pStmtKey, this._pstmtPool, this);
            }
            return new PoolableCallableStatement(this.getDelegate().prepareCall(pStmtKey._sql), pStmtKey, this._pstmtPool, this);
        }
        if (pStmtKey._stmtType == 0) {
            return new PoolablePreparedStatement(this.getDelegate().prepareStatement(pStmtKey._sql, pStmtKey._resultSetType, pStmtKey._resultSetConcurrency), pStmtKey, this._pstmtPool, this);
        }
        return new PoolableCallableStatement(this.getDelegate().prepareCall(pStmtKey._sql, pStmtKey._resultSetType, pStmtKey._resultSetConcurrency), pStmtKey, this._pstmtPool, this);
    }

    public void destroyObject(Object object, Object object2) throws Exception {
        if (object2 instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)object2).getInnermostDelegate().close();
        } else {
            ((PreparedStatement)object2).close();
        }
    }

    public boolean validateObject(Object object, Object object2) {
        return true;
    }

    public void activateObject(Object object, Object object2) throws Exception {
        ((DelegatingPreparedStatement)object2).activate();
    }

    public void passivateObject(Object object, Object object2) throws Exception {
        ((PreparedStatement)object2).clearParameters();
        ((DelegatingPreparedStatement)object2).passivate();
    }

    public String toString() {
        if (this._pstmtPool != null) {
            return "PoolingConnection: " + this._pstmtPool.toString();
        }
        return "PoolingConnection: null";
    }

    static class PStmtKey {
        protected String _sql = null;
        protected Integer _resultSetType = null;
        protected Integer _resultSetConcurrency = null;
        protected String _catalog = null;
        protected byte _stmtType = 0;

        PStmtKey(String string) {
            this._sql = string;
        }

        PStmtKey(String string, String string2) {
            this._sql = string;
            this._catalog = string2;
        }

        PStmtKey(String string, String string2, byte by) {
            this._sql = string;
            this._catalog = string2;
            this._stmtType = by;
        }

        PStmtKey(String string, int n, int n2) {
            this._sql = string;
            this._resultSetType = new Integer(n);
            this._resultSetConcurrency = new Integer(n2);
        }

        PStmtKey(String string, String string2, int n, int n2) {
            this._sql = string;
            this._catalog = string2;
            this._resultSetType = new Integer(n);
            this._resultSetConcurrency = new Integer(n2);
        }

        PStmtKey(String string, String string2, int n, int n2, byte by) {
            this._sql = string;
            this._catalog = string2;
            this._resultSetType = new Integer(n);
            this._resultSetConcurrency = new Integer(n2);
            this._stmtType = by;
        }

        public boolean equals(Object object) {
            try {
                PStmtKey pStmtKey = (PStmtKey)object;
                return (null == this._sql && null == pStmtKey._sql || this._sql.equals(pStmtKey._sql)) && (null == this._catalog && null == pStmtKey._catalog || this._catalog.equals(pStmtKey._catalog)) && (null == this._resultSetType && null == pStmtKey._resultSetType || this._resultSetType.equals(pStmtKey._resultSetType)) && (null == this._resultSetConcurrency && null == pStmtKey._resultSetConcurrency || this._resultSetConcurrency.equals(pStmtKey._resultSetConcurrency)) && this._stmtType == pStmtKey._stmtType;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }

        public int hashCode() {
            if (this._catalog == null) {
                return null == this._sql ? 0 : this._sql.hashCode();
            }
            return null == this._sql ? this._catalog.hashCode() : (this._catalog + this._sql).hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("PStmtKey: sql=");
            stringBuffer.append(this._sql);
            stringBuffer.append(", catalog=");
            stringBuffer.append(this._catalog);
            stringBuffer.append(", resultSetType=");
            stringBuffer.append(this._resultSetType);
            stringBuffer.append(", resultSetConcurrency=");
            stringBuffer.append(this._resultSetConcurrency);
            stringBuffer.append(", statmentType=");
            stringBuffer.append(this._stmtType);
            return stringBuffer.toString();
        }
    }
}

