/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.test;

import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

public class InvocationRecordingWrapper<T> {
    private List<String> records = new ArrayList<String>();
    private T proxy;

    public static <T> InvocationRecordingWrapper<T> wrap(T object, Class<T> type, Class<?> ... returnTypesToWrap) {
        InvocationRecordingWrapper<T> wrapper = new InvocationRecordingWrapper<T>();
        wrapper.proxy = InvocationRecordingWrapper.createProxy(wrapper, null, object, type, returnTypesToWrap);
        return wrapper;
    }

    private static Object createProxy(InvocationRecordingWrapper<?> wrapper, final String prefix, final Object object, Class<?> type, final Class<?> ... returnTypesToWrap) {
        return Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new InvocationHandler(){

            @Override
            public Object invoke(Object obj, Method method, Object[] parameters) throws Throwable {
                String record = InvocationRecordingWrapper.this.record(prefix, method, parameters);
                Object returnValue = method.invoke(object, parameters);
                if (returnValue != null) {
                    Class<?> returnValueClass = returnValue.getClass();
                    Class matchingClass = InvocationRecordingWrapper.tryGetMatchingClass(returnValueClass, returnTypesToWrap);
                    if (matchingClass != null) {
                        return InvocationRecordingWrapper.createProxy(InvocationRecordingWrapper.this, record, returnValue, matchingClass, returnTypesToWrap);
                    }
                    if (returnValueClass.isArray()) {
                        return InvocationRecordingWrapper.handleArray(InvocationRecordingWrapper.this, record, returnValue, returnValueClass, returnTypesToWrap);
                    }
                    if (returnValue instanceof List) {
                        return InvocationRecordingWrapper.handleList(InvocationRecordingWrapper.this, record, returnValue, returnTypesToWrap);
                    }
                }
                return returnValue;
            }
        });
    }

    private static Object handleList(InvocationRecordingWrapper<?> wrapper, String prefix, Object returnValue, Class<?> ... returnTypesToWrap) {
        List returnList = (List)returnValue;
        if (returnList.isEmpty()) {
            return returnValue;
        }
        ArrayList<Object> result = new ArrayList<Object>(returnList.size());
        int i = 0;
        while (i < returnList.size()) {
            Object element = returnList.get(i);
            Class<?> mc = InvocationRecordingWrapper.tryGetMatchingClass(element.getClass(), returnTypesToWrap);
            if (mc == null) {
                result.add(element);
            } else {
                result.add(InvocationRecordingWrapper.createProxy(wrapper, String.valueOf(prefix) + ".get(" + i + ")", element, mc, returnTypesToWrap));
            }
            ++i;
        }
        return result;
    }

    private static Object handleArray(InvocationRecordingWrapper<?> wrapper, String prefix, Object returnValue, Class<?> returnValueClass, Class<?> ... returnTypesToWrap) {
        Class<?> componentType = returnValueClass.getComponentType();
        Class<?> clazz = InvocationRecordingWrapper.tryGetMatchingClass(componentType, returnTypesToWrap);
        if (clazz == null) {
            return returnValue;
        }
        int size = Array.getLength(returnValue);
        Object newArray = Array.newInstance(componentType, size);
        int i = 0;
        while (i < size) {
            Array.set(newArray, i, InvocationRecordingWrapper.createProxy(wrapper, String.valueOf(prefix) + "[" + i + "]", Array.get(returnValue, i), clazz, returnTypesToWrap));
            ++i;
        }
        return newArray;
    }

    private static Class<?> tryGetMatchingClass(Class<?> clazz, Class<?> ... classes) {
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c.isAssignableFrom(clazz)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    private InvocationRecordingWrapper() {
    }

    public T getProxy() {
        return this.proxy;
    }

    public List<String> getRecords() {
        return this.records;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String record : this.records) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(record);
        }
        return builder.toString();
    }

    private String record(String prefix, Method method, Object[] parameters) {
        CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
        if (parameters != null) {
            Object[] objectArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Object parameter = objectArray[n2];
                builder.append(parameter);
                ++n2;
            }
        }
        String record = String.valueOf(prefix == null ? "" : String.valueOf(prefix) + ".") + method.getName() + "(" + builder + ")";
        this.records.add(record);
        return record;
    }
}

