/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics.dto;

import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Protein;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType
public class ProteinGroup {
    private String groupNumber;
    private String pseudoName;
    private double probability;
    private List<Protein> proteins;

    @XmlAttribute(name="group_number", required=true)
    public final String getGroupNumber() {
        return this.groupNumber;
    }

    public final void setGroupNumber(String groupNumber) {
        this.groupNumber = groupNumber;
    }

    @XmlAttribute(name="pseudo_name")
    public final String getPseudoName() {
        return this.pseudoName;
    }

    public final void setPseudoName(String pseudoName) {
        this.pseudoName = pseudoName;
    }

    @XmlAttribute(name="probability", required=true)
    public final double getProbability() {
        return this.probability;
    }

    public final void setProbability(double probability) {
        this.probability = probability;
    }

    @XmlElement(name="protein", namespace="http://regis-web.systemsbiology.net/protXML")
    public final List<Protein> getProteins() {
        return this.proteins;
    }

    public final void setProteins(List<Protein> proteins) {
        this.proteins = proteins;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PG[number=").append(this.groupNumber);
        if (this.pseudoName != null) {
            builder.append(", pseudoName=").append(this.pseudoName);
        }
        builder.append(", probability=").append(this.probability).append("]");
        if (this.proteins != null && this.proteins.size() > 0) {
            for (Protein protein : this.proteins) {
                builder.append("\n  ").append(protein);
            }
        }
        return builder.toString();
    }
}

