/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TableModelColumnHeader
implements Serializable {
    private static final long serialVersionUID = 35L;
    private String title;
    private String id;
    private int index;
    private DataTypeCode dataType;
    private EntityKind entityKindOrNull;
    private Map<String, String> properties;
    private int defaultColumnWidth = 150;
    private boolean hidden;
    private boolean editable;
    private boolean dynamicProperty;
    private boolean linkEntitiesOnly;
    protected Vocabulary vocabularyOrNull;

    public TableModelColumnHeader() {
    }

    public TableModelColumnHeader(String title, String id, int index) {
        this.setId(id);
        this.setTitle(title);
        this.setIndex(index);
    }

    public void setDataType(DataTypeCode dataType) {
        this.dataType = dataType;
        if (dataType == DataTypeCode.MATERIAL) {
            this.setEntityKind(EntityKind.MATERIAL);
        }
    }

    public DataTypeCode getDataType() {
        return this.dataType;
    }

    public String getTitle() {
        return this.title;
    }

    public void setId(String id) {
        this.id = id.replaceAll(" ", "_");
    }

    public final String getId() {
        return this.id;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setDefaultColumnWidth(int width) {
        this.defaultColumnWidth = width;
    }

    public int getDefaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    public final boolean isHidden() {
        return this.hidden;
    }

    public final void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isNumeric() {
        return this.dataType == DataTypeCode.REAL || this.dataType == DataTypeCode.INTEGER;
    }

    public boolean isVocabulary() {
        return this.dataType == DataTypeCode.CONTROLLEDVOCABULARY;
    }

    public Vocabulary tryGetVocabulary() {
        return this.vocabularyOrNull;
    }

    public void setVocabulary(Vocabulary vocabularyOrNull) {
        this.vocabularyOrNull = vocabularyOrNull;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setDynamicProperty(boolean dynamicProperty) {
        this.dynamicProperty = dynamicProperty;
    }

    public boolean isDynamicProperty() {
        return this.dynamicProperty;
    }

    public void setLinkEntitiesOnly(boolean linkEntitiesOnly) {
        this.linkEntitiesOnly = linkEntitiesOnly;
    }

    public boolean isLinkEntitiesOnly() {
        return this.linkEntitiesOnly;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public EntityKind tryGetEntityKind() {
        return this.entityKindOrNull;
    }

    public void setEntityKind(EntityKind entityKind) {
        this.entityKindOrNull = entityKind;
    }

    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public String tryToGetProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    public String toString() {
        return this.title;
    }
}

