/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.etlserver.IAutoArchiverPolicy;
import ch.systemsx.cisd.etlserver.plugins.BaseGroupingPolicy;
import ch.systemsx.cisd.etlserver.plugins.grouping.DatasetListWithTotal;
import ch.systemsx.cisd.etlserver.plugins.grouping.Grouping;
import ch.systemsx.cisd.etlserver.plugins.grouping.IGroupKeyProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class BySpacePolicy
extends BaseGroupingPolicy
implements IAutoArchiverPolicy {
    private final List<IGroupKeyProvider> providers = new ArrayList<IGroupKeyProvider>();

    public BySpacePolicy(Properties properties) {
        super(properties);
        this.providers.add(Grouping.Space);
        this.providers.add(Grouping.Project);
        this.providers.add(Grouping.Experiment);
        this.providers.add(Grouping.Sample);
        this.providers.add(Grouping.DataSet);
    }

    @Override
    public List<AbstractExternalData> filterDataSetsWithSizes(List<AbstractExternalData> dataSets) {
        List<AbstractExternalData> singleDataSet = this.findSingleBigDataSet(dataSets);
        if (singleDataSet != null) {
            return singleDataSet;
        }
        LinkedList<DatasetListWithTotal> buckets = new LinkedList<DatasetListWithTotal>();
        for (DatasetListWithTotal dsList : this.splitDataSetsInGroupsAccordingToCriteria(dataSets, Grouping.DataSetType)) {
            if (dsList.getCumulatedSize() < this.minArchiveSize) continue;
            buckets.add(dsList);
        }
        return this.findBestGroup(buckets);
    }

    private List<AbstractExternalData> findSingleBigDataSet(List<AbstractExternalData> dataSets) {
        for (AbstractExternalData ds : dataSets) {
            if (ds.getSize() < this.maxArchiveSize) continue;
            return Collections.singletonList(ds);
        }
        return null;
    }

    private List<AbstractExternalData> findBestGroup(List<DatasetListWithTotal> buckets) {
        List<DatasetListWithTotal> loopBuckets = buckets;
        for (IGroupKeyProvider provider : this.providers) {
            LinkedList<DatasetListWithTotal> newBuckets = new LinkedList<DatasetListWithTotal>();
            for (DatasetListWithTotal bucket : loopBuckets) {
                Collection<DatasetListWithTotal> splitResult = this.splitDataSetsInGroupsAccordingToCriteria(bucket, provider);
                boolean allDataSetsTooSmall = true;
                for (DatasetListWithTotal dsList : splitResult) {
                    if (dsList.getCumulatedSize() > this.maxArchiveSize) {
                        newBuckets.add(dsList);
                        allDataSetsTooSmall = false;
                        continue;
                    }
                    if (dsList.getCumulatedSize() < this.minArchiveSize) continue;
                    return dsList.getList();
                }
                if (!allDataSetsTooSmall) continue;
                List<AbstractExternalData> result = this.bundleBuckets(splitResult);
                if (result == null) {
                    throw new IllegalStateException("The bucket is full of data sets, that are too small but all together too big. Yet it's impossible to find a subset that would be big enough, but not too big. Probably min / max settings are incorrect");
                }
                return result;
            }
            loopBuckets = newBuckets;
        }
        return Collections.emptyList();
    }

    List<AbstractExternalData> bundleBuckets(Iterable<DatasetListWithTotal> buckets) {
        long total = 0L;
        LinkedList<AbstractExternalData> result = new LinkedList<AbstractExternalData>();
        for (DatasetListWithTotal bucket : buckets) {
            long bucketSize = bucket.getCumulatedSize();
            if (total + bucketSize >= this.maxArchiveSize) continue;
            result.addAll(bucket.getList());
            total += bucketSize;
        }
        if (total >= this.minArchiveSize) {
            return result;
        }
        return null;
    }
}

