/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.IArchiveCandidateDiscoverer;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.metaproject.MetaprojectIdentifierId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ArchiverDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class TagArchiveCandidateDiscoverer
implements IArchiveCandidateDiscoverer {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, TagArchiveCandidateDiscoverer.class);
    private static final String TAG_LIST = "tags";
    private final List<MetaprojectIdentifier> identifiers = new ArrayList<MetaprojectIdentifier>();

    public TagArchiveCandidateDiscoverer(Properties properties) {
        List<String> tags = PropertyUtils.getList(properties, TAG_LIST);
        if (tags.size() == 0) {
            operationLog.error((Object)"TagArchiveCandidateDiscoverer is configured with no tags. Nothing will be found.");
        }
        for (String tag : tags) {
            try {
                this.identifiers.add(MetaprojectIdentifier.parse(tag));
            }
            catch (Exception ex) {
                throw new ConfigurationFailureException("Invalid tag in property 'tags': " + ex.getMessage());
            }
        }
    }

    @Override
    public List<AbstractExternalData> findDatasetsForArchiving(IEncapsulatedOpenBISService openbis, ArchiverDataSetCriteria criteria) {
        if (this.identifiers.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<AbstractExternalData> result = new ArrayList<AbstractExternalData>();
        String dataSetTypeCode = criteria.tryGetDataSetTypeCode();
        for (MetaprojectIdentifier identifier : this.identifiers) {
            String user;
            String name = identifier.getMetaprojectName();
            Metaproject metaproject = openbis.tryGetMetaproject(name, user = identifier.getMetaprojectOwnerId());
            if (metaproject == null) continue;
            MetaprojectIdentifierId metaprojectId = new MetaprojectIdentifierId(identifier);
            List<AbstractExternalData> list = openbis.listNotArchivedDatasetsWithMetaproject(metaprojectId);
            for (AbstractExternalData dataSet : list) {
                if (!this.matches(dataSet, dataSetTypeCode)) continue;
                result.add(dataSet);
            }
        }
        return result;
    }

    private boolean matches(AbstractExternalData dataSet, String dataSetTypeCode) {
        if (dataSetTypeCode != null && !dataSet.getDataSetType().getCode().equals(dataSetTypeCode)) {
            return false;
        }
        if (!(dataSet instanceof PhysicalDataSet)) {
            return false;
        }
        PhysicalDataSet physicalDataSet = (PhysicalDataSet)dataSet;
        return DataSetArchivingStatus.AVAILABLE.equals(physicalDataSet.getStatus()) && !physicalDataSet.isPresentInArchive();
    }
}

