/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.thumbnails;

import ch.systemsx.cisd.openbis.dss.etl.dto.api.SimpleImageDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ThumbnailsStorageFormat;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.thumbnails.AbstractThumbnailsConfiguration;

public class ResolutionBasedThumbnailsConfiguration
extends AbstractThumbnailsConfiguration {
    private final int maxWidth;
    private final int maxHeight;
    private final boolean allowEnlarging;

    public ResolutionBasedThumbnailsConfiguration(int maxWidth, int maxHeight) {
        this(maxWidth, maxHeight, true);
    }

    public ResolutionBasedThumbnailsConfiguration(int maxWidth, int maxHeight, boolean allowEnlarging) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.allowEnlarging = allowEnlarging;
    }

    @Override
    public ThumbnailsStorageFormat getThumbnailsStorageFormat(SimpleImageDataConfig config) {
        ThumbnailsStorageFormat thumbnailsStorageFormat = super.getThumbnailsStorageFormat(config);
        thumbnailsStorageFormat.setMaxWidth(this.maxWidth);
        thumbnailsStorageFormat.setMaxHeight(this.maxHeight);
        thumbnailsStorageFormat.setAllowEnlarging(this.allowEnlarging);
        return thumbnailsStorageFormat;
    }

    @Override
    protected String getDefaultFileName() {
        return String.format("thumbnails_%dx%d%s.h5ar", this.maxWidth, this.maxHeight, this.getFirstTransformationCode());
    }
}

