/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.aggregation;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.report.ReportGeneratedCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableModelReference;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportingPluginType;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AggregationServicePanel
extends ContentPanel {
    static final String SERVICE_KEY_PARAM = "serviceKey";
    private static final String DSS_CODE_PARAM = "dss";
    private static final String GRID_SETTINGS_ID_PARAM = "gridSettingsId";
    private static final String GRID_HEADER_TEXT_PARAM = "gridHeaderText";
    private static final Set<String> PARAMETERS = new HashSet<String>();
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final ViewLocator viewLocator;
    private final String serviceKey;
    private final String dataStoreCode;
    private final String gridSettingsId;
    private final String gridHeaderText;

    static {
        PARAMETERS.add(SERVICE_KEY_PARAM);
        PARAMETERS.add(DSS_CODE_PARAM);
        PARAMETERS.add(GRID_SETTINGS_ID_PARAM);
        PARAMETERS.add(GRID_HEADER_TEXT_PARAM);
    }

    public AggregationServicePanel(IViewContext<ICommonClientServiceAsync> viewContext, String idPrefix, ViewLocator viewLocator) {
        super((Layout)new FitLayout());
        this.setId(String.valueOf(idPrefix) + "aggregation_service");
        this.viewContext = viewContext;
        this.viewLocator = viewLocator;
        this.serviceKey = viewLocator.getParameters().get(SERVICE_KEY_PARAM);
        this.dataStoreCode = viewLocator.getParameters().get(DSS_CODE_PARAM);
        this.gridSettingsId = viewLocator.getParameters().get(GRID_SETTINGS_ID_PARAM);
        this.gridHeaderText = viewLocator.getParameters().get(GRID_HEADER_TEXT_PARAM);
        if (this.getGridHeaderText() != null) {
            this.setHeading(this.getGridHeaderText());
        } else {
            this.setHeaderVisible(false);
        }
        if (this.areRequiredParametersSpecified()) {
            this.callAggregationService();
        } else {
            this.showErrorPage();
        }
    }

    private void showErrorPage() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h1>Missing Required Parameters</h1>\n");
        sb.append("<p>");
        if (this.serviceKey == null && this.dataStoreCode == null) {
            sb.append("The aggregation service and data store code must be specified in the URL query parameters. E.g:");
        } else if (this.serviceKey == null) {
            sb.append("The aggregation service must be specified in the URL query parameters. E.g:");
        } else {
            sb.append("The data store code must be specified in the URL query parameters. E.g:");
        }
        sb.append("<blockquote>");
        sb.append(Window.Location.getProtocol());
        sb.append("//");
        sb.append(Window.Location.getHost());
        sb.append("?viewMode=EMBEDDED#action=");
        sb.append("AGGREGATION_SERVICE");
        sb.append("serviceKey=[service key]&dss=[dss code]</blockquote>");
        sb.append("</p>");
        HTML content = new HTML(sb.toString());
        this.add((Widget)content);
        this.layout();
    }

    private boolean areRequiredParametersSpecified() {
        return this.serviceKey != null && this.dataStoreCode != null;
    }

    private void callAggregationService() {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Map<String, String> urlParameters = this.viewLocator.getParameters();
        for (Map.Entry<String, String> entry : urlParameters.entrySet()) {
            if (!this.isAggregationServiceParameter(entry.getKey())) continue;
            parameterMap.put(entry.getKey(), entry.getValue());
        }
        DatastoreServiceDescription description = DatastoreServiceDescription.reporting(this.serviceKey, "", new String[0], this.dataStoreCode, ReportingPluginType.AGGREGATION_TABLE_MODEL);
        AsyncCallback<TableModelReference> callback = ReportGeneratedCallback.create(this.viewContext, description, this.getGridSettingsId(), new AggregationServiceGeneratedAction(this));
        this.viewContext.getCommonService().createReportFromAggregationService(description, parameterMap, callback);
    }

    private boolean isAggregationServiceParameter(String parameterName) {
        return !PARAMETERS.contains(parameterName);
    }

    public String getGridHeaderText() {
        return this.gridHeaderText;
    }

    public String getGridSettingsId() {
        return this.gridSettingsId != null ? this.gridSettingsId : this.serviceKey;
    }

    private static class AggregationServiceGeneratedAction
    implements ReportGeneratedCallback.IOnReportComponentGeneratedAction {
        private final AggregationServicePanel layoutContainer;

        private AggregationServiceGeneratedAction(AggregationServicePanel layoutContainer) {
            this.layoutContainer = layoutContainer;
        }

        @Override
        public void execute(IDisposableComponent reportComponent) {
            this.layoutContainer.removeAll();
            this.layoutContainer.add(reportComponent.getComponent());
            this.layoutContainer.layout();
        }
    }
}

