/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.DataTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import com.extjs.gxt.ui.client.store.ListStore;
import java.util.List;

public final class DataTypeSelectionWidget
extends DropDownList<DataTypeModel, DataType> {
    private static final String EMPTY_RESULT = "data types";
    private static final String CHOOSE = "data type";
    public static final String SUFFIX = "data-type";
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public DataTypeSelectionWidget(IViewContext<ICommonClientServiceAsync> viewContext, boolean mandatory) {
        super(viewContext, SUFFIX, "data_type", "code", CHOOSE, EMPTY_RESULT);
        this.viewContext = viewContext;
        FieldUtil.setMandatoryFlag(this, mandatory);
    }

    public final DataType tryGetSelectedDataType() {
        return (DataType)super.tryGetSelected();
    }

    @Override
    protected List<DataTypeModel> convertItems(List<DataType> result) {
        return DataTypeModel.convert(result);
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<DataType>> callback) {
        this.viewContext.getService().listDataTypes(new ListDataTypesCallback(this.viewContext));
        callback.ignore();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.EMPTY_ARRAY;
    }

    private final class ListDataTypesCallback
    extends AbstractAsyncCallback<List<DataType>> {
        ListDataTypesCallback(IViewContext<ICommonClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected final void process(List<DataType> result) {
            ListStore dataTypeStore = DataTypeSelectionWidget.this.getStore();
            dataTypeStore.removeAll();
            dataTypeStore.add(DataTypeSelectionWidget.this.convertItems(result));
            if (dataTypeStore.getCount() > 0) {
                DataTypeSelectionWidget.this.setEmptyText(this.viewContext.getMessage("combobox_choose", DataTypeSelectionWidget.CHOOSE));
                DataTypeSelectionWidget.this.setReadOnly(false);
            } else {
                DataTypeSelectionWidget.this.setEmptyText(this.viewContext.getMessage("combobox_empty", DataTypeSelectionWidget.EMPTY_RESULT));
                DataTypeSelectionWidget.this.setReadOnly(true);
            }
            DataTypeSelectionWidget.this.applyEmptyText();
        }
    }
}

